/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.translation.normation.normationjpn;

import de.kugihan.dictionaryformids.dataaccess.CsvFile;
import de.kugihan.dictionaryformids.general.DictionaryException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class LookupTable {
    private Hashtable romajiToHiraganaTable = null;
    private Hashtable romajiToKatakanaTable = null;
    private Hashtable katakanaToRomajiTable = null;
    private Hashtable hiraganaToRomajiTable = null;
    private final int maxSize = 20480;

    private Hashtable initialiseTable(String filename, boolean reverse) throws UnsupportedEncodingException, IOException {
        Hashtable<String, String> map = new Hashtable<String, String>();
        try {
            String left;
            CsvFile file = new CsvFile(filename, '=', "UTF-8", 20480);
            file.readCsvFileComplete();
            while (!(left = file.getWord().toString()).equals("")) {
                String right = file.getWord().toString();
                if (!reverse) {
                    map.put(left, right);
                    continue;
                }
                map.put(right, left);
            }
        }
        catch (DictionaryException e) {
            System.out.println(e);
        }
        return map;
    }

    public Hashtable getRomajiToHiraganaTable() {
        if (this.romajiToHiraganaTable == null) {
            try {
                this.romajiToHiraganaTable = this.initialiseTable("/char_lists/romaji_hiragana_utf8.txt", false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.romajiToHiraganaTable;
    }

    public Hashtable getRomajiToKatakanaTable() {
        if (this.romajiToKatakanaTable == null) {
            try {
                this.romajiToKatakanaTable = this.initialiseTable("/char_lists/romaji_katakana_utf8.txt", false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.romajiToKatakanaTable;
    }

    public Hashtable getHiraganaToRomajiTable() {
        if (this.hiraganaToRomajiTable == null) {
            try {
                this.hiraganaToRomajiTable = this.initialiseTable("/char_lists/romaji_hiragana_utf8.txt", true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.hiraganaToRomajiTable;
    }

    public Hashtable getKatakanaToRomajiTable() {
        if (this.katakanaToRomajiTable == null) {
            try {
                this.katakanaToRomajiTable = this.initialiseTable("/char_lists/romaji_katakana_utf8.txt", true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.katakanaToRomajiTable;
    }
}

