/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.translation.normation;

import de.kugihan.dictionaryformids.general.Util;
import de.kugihan.dictionaryformids.translation.SearchedWord;
import de.kugihan.dictionaryformids.translation.normation.Normation;
import de.kugihan.dictionaryformids.translation.normation.normationjpn.Parser;
import java.util.Vector;

public class NormationJpn
extends Normation {
    Parser parserObj = new Parser();
    private final int HIRAGANA = 0;
    private final int KATAKANA = 1;

    public Vector searchWord(String text) {
        Vector<SearchedWord> words = new Vector<SearchedWord>(2);
        text = Util.convertToLowerCase(new StringBuffer(text)).toString();
        int i = 0;
        char sub = text.charAt(i);
        while (sub == '*' || sub == '?') {
            sub = text.charAt(++i);
        }
        if (this.isRomaji(sub)) {
            String hiraganaWord = this.parserObj.convert(text, 0, true);
            words.addElement(new SearchedWord(hiraganaWord));
            String katakanaWord = this.parserObj.convert(text, 1, true);
            words.addElement(new SearchedWord(katakanaWord));
        } else if (this.isHiragana(sub)) {
            words.addElement(new SearchedWord(text));
            String romajiWord = this.parserObj.convert(text, 0, false);
            String katakanaWord = this.parserObj.convert(romajiWord, 1, true);
            words.addElement(new SearchedWord(katakanaWord));
        } else if (this.isKatakana(sub)) {
            words.addElement(new SearchedWord(text));
            String romajiWord = this.parserObj.convert(text, 1, false);
            String hiraganaWord = this.parserObj.convert(romajiWord, 0, true);
            words.addElement(new SearchedWord(hiraganaWord));
        } else {
            System.err.println("Illegal input string in normationjpn.");
        }
        return words;
    }

    public boolean isRomaji(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public boolean isHiragana(char c) {
        return c >= '\u3040' && c <= '\u309f';
    }

    public boolean isKatakana(char c) {
        return c >= '\u30a0' && c <= '\u30ff';
    }
}

