/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.translation;

import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.Util;
import de.kugihan.dictionaryformids.translation.Translation;
import de.kugihan.dictionaryformids.translation.TranslationExecution;
import de.kugihan.dictionaryformids.translation.TranslationParameters;
import de.kugihan.dictionaryformids.translation.TranslationResult;

class TranslationThread
implements Runnable {
    protected volatile boolean translationIsCancelled = false;
    protected Translation translate = null;
    protected Thread ownExecutionThread;
    protected TranslationParameters translationParametersObj;

    public TranslationThread(TranslationParameters translationParametersObjParam) {
        this.translationParametersObj = translationParametersObjParam;
    }

    public void setOwnExecutionThread(Thread threadParam) {
        this.ownExecutionThread = threadParam;
    }

    public void run() {
        try {
            this.doTranslation();
        }
        catch (Throwable t) {
            Util.getUtil().log(t);
        }
    }

    public void runInForeground() throws DictionaryException {
        this.doTranslation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTranslation() throws DictionaryException {
        TranslationThread translationThread = this;
        synchronized (translationThread) {
            if (!this.translationIsCancelled) {
                TranslationExecution.translationResultHMIObj.deletePreviousTranslationResult();
            }
        }
        if (this.translationParametersObj.isExecuteInBackground()) {
            this.ownExecutionThread.setPriority(3);
        }
        if (!this.translationParametersObj.toBeTranslatedWordTextIsEmpty()) {
            this.translate = new Translation(this.translationParametersObj);
            TranslationResult resultOfTranslation = null;
            if (!this.translationIsCancelled) {
                resultOfTranslation = this.translate.getTranslationResult();
            }
            TranslationThread translationThread2 = this;
            synchronized (translationThread2) {
                if (!this.translationIsCancelled) {
                    TranslationExecution.translationResultHMIObj.newTranslationResult(resultOfTranslation);
                }
            }
            this.translate = null;
        }
    }

    public synchronized void cancelTranslation() {
        this.translationIsCancelled = true;
        if (this.translate != null) {
            this.translate.cancelTranslation();
            this.ownExecutionThread.interrupt();
        }
    }
}

