/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.translation;

import de.kugihan.dictionaryformids.dataaccess.CsvFile;
import de.kugihan.dictionaryformids.dataaccess.DictionaryDataFile;
import de.kugihan.dictionaryformids.dataaccess.LanguageDefinition;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.Util;
import de.kugihan.dictionaryformids.translation.DirectoryFileLocation;
import de.kugihan.dictionaryformids.translation.SearchIndicator;
import de.kugihan.dictionaryformids.translation.SearchedWord;
import de.kugihan.dictionaryformids.translation.SingleTranslation;
import de.kugihan.dictionaryformids.translation.TextOfLanguage;
import de.kugihan.dictionaryformids.translation.TranslationParameters;
import de.kugihan.dictionaryformids.translation.TranslationResult;
import de.kugihan.dictionaryformids.translation.normation.Normation;
import java.util.Vector;

public class Translation {
    public String toBeTranslatedWordText;
    public boolean[] inputLanguages;
    public boolean[] outputLanguages;
    boolean searchSubExpressionStart;
    boolean searchSubExpressionEnd;
    int maxHits;
    int durationForCancelSearch;
    public static final char wildcardAnySeriesOfCharacter = '*';
    public static final char wildcardAnySingleCharacter = '?';
    public static final char noSearchSubExpressionCharacter = '/';
    protected TranslationResult resultOfTranslation;
    long startTime;
    volatile boolean translationIsCancelled = false;
    private static final char[] weakEncrypt_password = "EspernatoEstasBona".toCharArray();

    public Translation(TranslationParameters translationParametersObj) throws DictionaryException {
        this.toBeTranslatedWordText = translationParametersObj.getToBeTranslatedWordText();
        this.inputLanguages = translationParametersObj.getInputLanguages();
        this.outputLanguages = translationParametersObj.getOutputLanguages();
        this.searchSubExpressionStart = translationParametersObj.isSearchSubExpressionStart();
        this.searchSubExpressionEnd = translationParametersObj.isSearchSubExpressionEnd();
        this.maxHits = translationParametersObj.getMaxHits();
        this.durationForCancelSearch = translationParametersObj.getDurationForCancelSearch();
        if (this.inputLanguages.length != DictionaryDataFile.numberOfAvailableLanguages || this.outputLanguages.length != DictionaryDataFile.numberOfAvailableLanguages) {
            throw new DictionaryException("Incorrect number of array elements for inputLanguages/outputLanguages");
        }
    }

    static int positionFirstWildcardCharacter(String word) {
        int indexWildcardAnySeriesOfCharacters = word.indexOf(42);
        int indexWildcardAnySingleCharacter = word.indexOf(63);
        int index = indexWildcardAnySingleCharacter == -1 && indexWildcardAnySeriesOfCharacters == -1 ? -1 : (indexWildcardAnySingleCharacter == -1 && indexWildcardAnySeriesOfCharacters > -1 ? indexWildcardAnySeriesOfCharacters : (indexWildcardAnySingleCharacter > -1 && indexWildcardAnySeriesOfCharacters == -1 ? indexWildcardAnySingleCharacter : (indexWildcardAnySingleCharacter < indexWildcardAnySeriesOfCharacters ? indexWildcardAnySingleCharacter : indexWildcardAnySeriesOfCharacters)));
        return index;
    }

    static String expressionTillWildcard(String word) {
        return word.substring(0, Translation.positionFirstWildcardCharacter(word));
    }

    public TranslationResult getTranslationResult() {
        this.resultOfTranslation = new TranslationResult();
        this.startTime = System.currentTimeMillis();
        Util.memCheck("start translation: ");
        try {
            for (int languageCount = 0; languageCount < DictionaryDataFile.numberOfAvailableLanguages; ++languageCount) {
                LanguageDefinition languageDefinitionObj = DictionaryDataFile.supportedLanguages[languageCount];
                if (!languageDefinitionObj.isSearchable || !this.inputLanguages[languageCount]) continue;
                int inputLanguageForSearch = languageCount;
                Normation normationObj = DictionaryDataFile.supportedLanguages[inputLanguageForSearch].normationObj;
                Vector searchWords = normationObj.searchWord(this.toBeTranslatedWordText);
                for (int wordCount = 0; wordCount < searchWords.size(); ++wordCount) {
                    SearchedWord searchWord = (SearchedWord)searchWords.elementAt(wordCount);
                    String nonNormatedWord = searchWord.word;
                    String toBeTranslatedWordNormated = normationObj.normateWord(new StringBuffer(nonNormatedWord), true).toString();
                    if (toBeTranslatedWordNormated.length() <= 0) continue;
                    this.searchTranslationForNormatedWord(inputLanguageForSearch, toBeTranslatedWordNormated);
                }
            }
        }
        catch (Throwable t) {
            Util.getUtil().log(t);
        }
        long endTime = System.currentTimeMillis();
        this.resultOfTranslation.executionTime = endTime - this.startTime;
        Util.memCheck("end translation: ");
        return this.resultOfTranslation;
    }

    public void searchTranslationForNormatedWord(int inputLanguageForSearch, String toBeTranslatedWordNormated) throws DictionaryException {
        boolean containsWildcard = Translation.positionFirstWildcardCharacter(toBeTranslatedWordNormated) >= 0;
        String initialSearchExpression = containsWildcard ? Translation.expressionTillWildcard(toBeTranslatedWordNormated) : toBeTranslatedWordNormated;
        int initialSearchExpressionLength = initialSearchExpression.length();
        String languagePostfix = DictionaryDataFile.supportedLanguages[inputLanguageForSearch].languageFilePostfix;
        String searchListFileName = DictionaryDataFile.getPathDataFiles() + DictionaryDataFile.prefixSearchListFile + languagePostfix + DictionaryDataFile.suffixSearchListFile;
        CsvFile searchListFile = new CsvFile(searchListFileName, DictionaryDataFile.searchListFileSeparationCharacter, DictionaryDataFile.searchListCharEncoding, DictionaryDataFile.searchListFileMaxSize);
        Util.memCheck("searchfile open: ");
        String indexFileNumber = null;
        boolean lastIndexFileSearched = false;
        searchListFile.setPositionBefore(initialSearchExpression);
        while (!searchListFile.endOfDictionaryReached) {
            String wordInIndex = searchListFile.getWord().toString();
            if (containsWildcard) {
                String firstPartWordInIndex;
                int endOfFirstPartWordInIndex = initialSearchExpressionLength;
                int wordInIndexLength = wordInIndex.length();
                if (wordInIndexLength < initialSearchExpressionLength) {
                    endOfFirstPartWordInIndex = wordInIndexLength;
                }
                if ((firstPartWordInIndex = wordInIndex.substring(0, endOfFirstPartWordInIndex)).startsWith(initialSearchExpression)) {
                    if (!lastIndexFileSearched && indexFileNumber != null && this.searchInIndexFileBreakCondition(inputLanguageForSearch, toBeTranslatedWordNormated, indexFileNumber) || this.searchInIndexFileBreakCondition(inputLanguageForSearch, toBeTranslatedWordNormated, indexFileNumber = searchListFile.getWord().toString())) break;
                    lastIndexFileSearched = true;
                    continue;
                }
                if (firstPartWordInIndex.compareTo(initialSearchExpression) > 0) {
                    if (lastIndexFileSearched || indexFileNumber == null || !this.searchInIndexFileBreakCondition(inputLanguageForSearch, toBeTranslatedWordNormated, indexFileNumber)) break;
                    break;
                }
                indexFileNumber = searchListFile.getWord().toString();
                continue;
            }
            if (wordInIndex.compareTo(initialSearchExpression) >= 0) {
                if (indexFileNumber != null && this.searchInIndexFileBreakCondition(inputLanguageForSearch, toBeTranslatedWordNormated, indexFileNumber)) break;
                boolean continueSearch = false;
                if (wordInIndex.startsWith(initialSearchExpression)) {
                    if (wordInIndex.length() > initialSearchExpression.length()) {
                        if (wordInIndex.charAt(initialSearchExpression.length()) == ' ') {
                            continueSearch = true;
                        }
                    } else {
                        continueSearch = true;
                    }
                }
                if (!continueSearch) break;
                indexFileNumber = searchListFile.getWord().toString();
                continue;
            }
            indexFileNumber = searchListFile.getWord().toString();
        }
        if (searchListFile.endOfDictionaryReached && !lastIndexFileSearched) {
            this.searchInIndexFileBreakCondition(inputLanguageForSearch, toBeTranslatedWordNormated, indexFileNumber);
        }
        searchListFile = null;
    }

    public boolean searchInIndexFileBreakCondition(int inputLanguageForSearch, String toBeTranslatedWordNormated, String indexFileNumber) throws DictionaryException {
        if (this.translationBreakCondition()) {
            return true;
        }
        this.searchInIndexFile(inputLanguageForSearch, toBeTranslatedWordNormated, indexFileNumber);
        return this.translationBreakCondition();
    }

    public void searchInIndexFile(int inputLanguageForSearch, String toBeTranslatedWordNormated, String indexFileNumber) throws DictionaryException {
        Util.getUtil().logDebug("indexFileNumber " + indexFileNumber);
        String languagePostfix = DictionaryDataFile.supportedLanguages[inputLanguageForSearch].languageFilePostfix;
        String indexFileName = DictionaryDataFile.getPathDataFiles() + DictionaryDataFile.prefixIndexFile + languagePostfix + indexFileNumber + DictionaryDataFile.suffixIndexFile;
        boolean containsWildcard = Translation.positionFirstWildcardCharacter(toBeTranslatedWordNormated) >= 0;
        String searchExpression = toBeTranslatedWordNormated;
        String initialSearchExpression = containsWildcard ? Translation.expressionTillWildcard(toBeTranslatedWordNormated) : toBeTranslatedWordNormated;
        int initialSearchExpressionLength = initialSearchExpression.length();
        String indexStringLine = null;
        Util.getUtil().logDebug("indexFileName " + indexFileName);
        CsvFile indexFile = new CsvFile(indexFileName, DictionaryDataFile.indexFileSeparationCharacter, DictionaryDataFile.indexCharEncoding, DictionaryDataFile.indexFileMaxSize);
        Util.memCheck("indexfile open: ");
        indexFile.setPositionBefore(initialSearchExpression);
        while (!indexFile.endOfDictionaryReached) {
            String firstPartIndexEntry;
            String indexEntry = indexFile.getWord().toString();
            if (!containsWildcard) {
                if (indexEntry.compareTo(searchExpression) < 0) {
                    indexFile.skipRestOfLine();
                    continue;
                }
                if (!indexEntry.startsWith(searchExpression)) break;
                if (this.noWildcardMatchRest(searchExpression, indexEntry)) {
                    indexStringLine = indexFile.getRestOfLine().toString();
                    this.getDictionaryEntry(inputLanguageForSearch, indexStringLine);
                    continue;
                }
                indexFile.skipRestOfLine();
                continue;
            }
            int endOfFirstPartIndexEntry = initialSearchExpressionLength;
            int indexEntryLength = indexEntry.length();
            if (indexEntryLength < initialSearchExpressionLength) {
                endOfFirstPartIndexEntry = indexEntryLength;
            }
            if (initialSearchExpression.compareTo(firstPartIndexEntry = indexEntry.substring(0, endOfFirstPartIndexEntry)) < 0) break;
            if (this.wildcardMatch(indexEntry, 0, indexEntry.length(), searchExpression, 0, searchExpression.length())) {
                indexStringLine = indexFile.getRestOfLine().toString();
                this.getDictionaryEntry(inputLanguageForSearch, indexStringLine);
                continue;
            }
            indexFile.skipRestOfLine();
        }
    }

    public final boolean wildcardMatch(String toBeSearchedExpression, int positionCharacterToBeSearchedExpression, int lengthToBeSearchedExpression, String wildcardExpression, int positionCharacterWildcardExpression, int lengthWildcardExpression) {
        boolean expressionsMatch = false;
        if (positionCharacterWildcardExpression == lengthWildcardExpression) {
            expressionsMatch = positionCharacterToBeSearchedExpression == lengthToBeSearchedExpression ? true : (lengthToBeSearchedExpression > positionCharacterToBeSearchedExpression && this.searchSubExpressionEnd ? toBeSearchedExpression.charAt(positionCharacterToBeSearchedExpression) == ' ' : false);
        } else if (positionCharacterToBeSearchedExpression == lengthToBeSearchedExpression) {
            boolean restIsAnySeriesOfCharacter = true;
            for (int position = positionCharacterWildcardExpression; position < lengthWildcardExpression; ++position) {
                if (wildcardExpression.charAt(position) == '*') continue;
                restIsAnySeriesOfCharacter = false;
                break;
            }
            expressionsMatch = restIsAnySeriesOfCharacter;
        } else {
            char characterToBeSearchedExpression = toBeSearchedExpression.charAt(positionCharacterToBeSearchedExpression);
            char characterWildcardExpression = wildcardExpression.charAt(positionCharacterWildcardExpression);
            if (characterWildcardExpression == '?') {
                expressionsMatch = this.wildcardMatch(toBeSearchedExpression, positionCharacterToBeSearchedExpression + 1, lengthToBeSearchedExpression, wildcardExpression, positionCharacterWildcardExpression + 1, lengthWildcardExpression);
            } else if (characterWildcardExpression == '*') {
                for (int position = positionCharacterToBeSearchedExpression; position <= lengthToBeSearchedExpression && !(expressionsMatch = this.wildcardMatch(toBeSearchedExpression, position, lengthToBeSearchedExpression, wildcardExpression, positionCharacterWildcardExpression + 1, lengthWildcardExpression)); ++position) {
                }
            } else if (characterWildcardExpression == characterToBeSearchedExpression) {
                expressionsMatch = this.wildcardMatch(toBeSearchedExpression, positionCharacterToBeSearchedExpression + 1, lengthToBeSearchedExpression, wildcardExpression, positionCharacterWildcardExpression + 1, lengthWildcardExpression);
            }
        }
        return expressionsMatch;
    }

    public boolean noWildcardMatchRest(String searchExpression, String indexEntry) {
        int indexEntryLength;
        int searchExpressionLength = searchExpression.length();
        if (searchExpressionLength == (indexEntryLength = indexEntry.length())) {
            return true;
        }
        return indexEntryLength > searchExpressionLength && this.searchSubExpressionEnd && indexEntry.charAt(searchExpressionLength) == ' ';
    }

    public void getDictionaryEntry(int inputLanguageForSearch, String indexStringLine) throws DictionaryException {
        int posIndexFileSeparatorIndexEntries;
        int posFirstCharIndexString = 0;
        do {
            int posLastCharIndexString = (posIndexFileSeparatorIndexEntries = indexStringLine.indexOf(DictionaryDataFile.indexFileSeparatorIndexEntries, posFirstCharIndexString)) == -1 ? indexStringLine.length() : posIndexFileSeparatorIndexEntries;
            String indexString = indexStringLine.substring(posFirstCharIndexString, posLastCharIndexString);
            posFirstCharIndexString = posLastCharIndexString + 1;
            int posIndexFileSeparatorFileNumberToPosition = indexString.indexOf(DictionaryDataFile.indexFileSeparatorFileNumberToPosition);
            String directoryFileNumberString = indexString.substring(0, posIndexFileSeparatorFileNumberToPosition);
            int directoryFileNumber = Integer.parseInt(directoryFileNumberString);
            int posIndexFileSeparatorFilePositionToSearchIndicator = indexString.indexOf(DictionaryDataFile.indexFileSeparatorFilePositionToSearchIndicator, posIndexFileSeparatorFileNumberToPosition + 1);
            if (posIndexFileSeparatorFilePositionToSearchIndicator == -1) {
                throw new DictionaryException("Indexfile has no searchindicator - use DictionaryGeneration 2.4.4 or newer");
            }
            int positionInDirectoryFile = Integer.valueOf(indexString.substring(posIndexFileSeparatorFileNumberToPosition + 1, posIndexFileSeparatorFilePositionToSearchIndicator));
            SearchIndicator searchIndicatorObj = new SearchIndicator(indexString.charAt(posIndexFileSeparatorFilePositionToSearchIndicator + 1));
            if (!this.searchSubExpressionStart && !searchIndicatorObj.isBeginOfExpression()) continue;
            LanguageDefinition supportedLanguage = DictionaryDataFile.supportedLanguages[inputLanguageForSearch];
            String postfixDictionaryFile = supportedLanguage.hasSeparateDictionaryFile ? supportedLanguage.languageFilePostfix : "";
            if (this.translationBreakCondition()) break;
            DirectoryFileLocation directoryFileLocation = new DirectoryFileLocation(directoryFileNumber, postfixDictionaryFile, positionInDirectoryFile);
            this.getTranslation(inputLanguageForSearch, directoryFileLocation, searchIndicatorObj.isBeginOfExpression());
        } while (posIndexFileSeparatorIndexEntries > 0);
    }

    public void getTranslation(int inputLanguageForSearch, DirectoryFileLocation directoryFileLocation, boolean foundAtBeginOfExpression) throws DictionaryException {
        String dictionaryFileName = DictionaryDataFile.getPathDataFiles() + DictionaryDataFile.prefixDictionaryFile + directoryFileLocation.postfixDictionaryFile + directoryFileLocation.directoryFileNumber + DictionaryDataFile.suffixDictionaryFile;
        Util.getUtil().logDebug("dictionaryFileName " + dictionaryFileName);
        Util.getUtil().logDebug("position " + String.valueOf(directoryFileLocation.positionInDirectoryFile));
        CsvFile dictionaryFile = new CsvFile(dictionaryFileName, DictionaryDataFile.dictionaryFileSeparationCharacter, DictionaryDataFile.dictionaryCharEncoding, DictionaryDataFile.dictionaryFileMaxSize, directoryFileLocation.positionInDirectoryFile);
        Util.memCheck("dictionaryfile open: ");
        TextOfLanguage fromText = null;
        Vector<TextOfLanguage> toTexts = new Vector<TextOfLanguage>();
        for (int indexLanguage = 0; indexLanguage < DictionaryDataFile.numberOfAvailableLanguages; ++indexLanguage) {
            StringBuffer word = dictionaryFile.getWord();
            if ("weakCrypt".equals(DictionaryDataFile.fileEncodingFormat)) {
                Translation.weakDecrypt(word);
            }
            if (inputLanguageForSearch == indexLanguage) {
                Util.getUtil().convertFieldAndLineSeparatorChars(word);
                fromText = new TextOfLanguage(word.toString(), indexLanguage);
            }
            if (!this.outputLanguages[indexLanguage]) continue;
            Util.getUtil().convertFieldAndLineSeparatorChars(word);
            toTexts.addElement(new TextOfLanguage(word.toString(), indexLanguage));
        }
        this.addTranslation(fromText, toTexts, foundAtBeginOfExpression, directoryFileLocation);
        dictionaryFile = null;
    }

    private static void weakDecryptOld(StringBuffer word) {
        int n = word.length();
        while (--n >= 0) {
            char ch = word.charAt(n);
            if (ch < '<' || ch >= '|') continue;
            word.setCharAt(n, (char)((ch - 60 ^ 0x2B) + 60));
        }
    }

    private static void weakDecrypt(StringBuffer word) {
        int n = 0;
        int limit = word.length();
        for (int i = 0; i < limit; ++i) {
            char ch = word.charAt(i);
            if (ch >= '<' && ch < '|') {
                ch = (char)(((ch - 60 ^ 0x2B) - weakEncrypt_password[n] + 256) % 64 + 60);
                word.setCharAt(i, ch);
                n = (n + 1) % weakEncrypt_password.length;
                continue;
            }
            n = 0;
        }
    }

    public void addTranslation(TextOfLanguage fromText, Vector toTexts, boolean foundAtBeginOfExpression, DirectoryFileLocation directoryFileLocation) {
        SingleTranslation translation;
        int translationsCompared;
        int indexTranslation;
        SingleTranslation newSingleTranslation = new SingleTranslation(fromText, toTexts, foundAtBeginOfExpression, fromText.getLanguageIndex(), directoryFileLocation);
        int numberOfTranslations = this.resultOfTranslation.translations.size();
        for (indexTranslation = 0; indexTranslation < numberOfTranslations && (translationsCompared = newSingleTranslation.compareTo(translation = (SingleTranslation)this.resultOfTranslation.translations.elementAt(indexTranslation))) != 0; ++indexTranslation) {
            if (translationsCompared >= 0) continue;
            this.resultOfTranslation.insertTranslationAt(newSingleTranslation, indexTranslation);
            break;
        }
        if (indexTranslation == numberOfTranslations) {
            this.resultOfTranslation.addTranslation(newSingleTranslation);
        }
    }

    boolean translationBreakCondition() {
        if (this.resultOfTranslation.numberOfFoundTranslations() >= this.maxHits) {
            this.resultOfTranslation.translationBreakOccurred = true;
            this.resultOfTranslation.translationBreakReason = 3;
            return true;
        }
        if (System.currentTimeMillis() - this.startTime >= (long)this.durationForCancelSearch) {
            this.resultOfTranslation.translationBreakOccurred = true;
            this.resultOfTranslation.translationBreakReason = 2;
            return true;
        }
        if (this.translationIsCancelled) {
            this.resultOfTranslation.translationBreakOccurred = true;
            this.resultOfTranslation.translationBreakReason = 1;
            return true;
        }
        return false;
    }

    public void cancelTranslation() {
        this.translationIsCancelled = true;
    }
}

