/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.translation;

import de.kugihan.dictionaryformids.general.Util;
import de.kugihan.dictionaryformids.translation.DirectoryFileLocation;
import de.kugihan.dictionaryformids.translation.TextOfLanguage;
import java.util.Vector;

public class SingleTranslation {
    protected TextOfLanguage fromText;
    protected Vector toTexts;
    protected boolean foundAtBeginOfExpression;
    protected DirectoryFileLocation directoryFileLocation;
    protected int primarySortNumber;
    protected int internalSortNumber;

    public SingleTranslation(TextOfLanguage fromTextParam, Vector toTextsParam, boolean foundAtBeginOfExpressionParam, int primarySortNumberParam, DirectoryFileLocation directoryFileLocationParam) {
        this.fromText = fromTextParam;
        this.toTexts = toTextsParam;
        this.foundAtBeginOfExpression = foundAtBeginOfExpressionParam;
        this.primarySortNumber = primarySortNumberParam;
        this.directoryFileLocation = directoryFileLocationParam;
        this.determineInternalSortNumber();
    }

    protected void determineInternalSortNumber() {
        int numberOfWords = 1;
        boolean inSeparator = false;
        for (int charCount = 0; charCount < this.fromText.text.length(); ++charCount) {
            boolean isSeparatorCharacter = Util.isSeparatorCharacter(this.fromText.text.charAt(charCount));
            if (!inSeparator && isSeparatorCharacter) {
                ++numberOfWords;
            }
            inSeparator = isSeparatorCharacter;
        }
        this.internalSortNumber = numberOfWords;
    }

    int compareTo(SingleTranslation otherSingleTranslation) {
        int internalSortNumberCompared;
        int primarySortNumberCompared;
        int directoryFileLocationCompared = this.directoryFileLocation.compareTo(otherSingleTranslation.directoryFileLocation);
        int compareResult = directoryFileLocationCompared == 0 && this.fromText.getLanguageIndex() == otherSingleTranslation.getFromText().getLanguageIndex() ? directoryFileLocationCompared : ((primarySortNumberCompared = this.primarySortNumber - otherSingleTranslation.primarySortNumber) == 0 ? (this.foundAtBeginOfExpression == otherSingleTranslation.foundAtBeginOfExpression ? ((internalSortNumberCompared = this.internalSortNumber - otherSingleTranslation.internalSortNumber) == 0 ? directoryFileLocationCompared : internalSortNumberCompared) : (this.foundAtBeginOfExpression ? -1 : 1)) : primarySortNumberCompared);
        return compareResult;
    }

    public TextOfLanguage getFromText() {
        return this.fromText;
    }

    public Vector getToTexts() {
        return this.toTexts;
    }

    public int getNumberOfToTexts() {
        return this.toTexts.size();
    }

    public TextOfLanguage getToTextAt(int index) {
        return (TextOfLanguage)this.toTexts.elementAt(index);
    }
}

