/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.hmi_java_se;

import de.kugihan.dictionaryformids.hmi_java_se.DefaultSortTableHeaderRenderer;
import de.kugihan.dictionaryformids.hmi_java_se.SortableTableModel;
import de.kugihan.dictionaryformids.hmi_java_se.SortedTableListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SortedTable
extends JTable {
    private TableModel model;
    private Model sortModel;
    private Listener listener = new Listener();
    private Vector listeners = new Vector();
    private Hashtable comparators = new Hashtable();
    private boolean reactionResort = true;
    private boolean doNotAlterSortingDirection = true;
    private JScrollPane sp = null;

    public SortedTable() {
        this.sortModel = new Model();
        JTableHeader header = this.getTableHeader();
        header.addMouseListener(this.listener);
        TableCellRenderer renderer = header.getDefaultRenderer();
        if (renderer instanceof SortedTableListener) {
            this.addSortedTableListener((SortedTableListener)((Object)renderer));
        }
        this.createDefaultComparators();
        super.setModel(this.sortModel);
    }

    public SortedTable(TableModel model) {
        this();
        this.setModel(model);
    }

    public SortedTable(SortableTableModel model) {
        this();
        this.setModel(model);
    }

    @Override
    public void setModel(TableModel model) {
        if (model == null) {
            throw new IllegalArgumentException("Model must not be null");
        }
        if (this.sortModel == null) {
            super.setModel(model);
        } else {
            TableModel oldModel = this.model;
            this.model = model;
            this.sortModel.modelChange(oldModel, model);
        }
    }

    public TableModel getOriginalModel() {
        return this.model;
    }

    public int getOriginalSelectedRow() {
        int row = this.getSelectedRow();
        if (row != -1) {
            row = this.sortModel.convertSortToOriginal(row);
        }
        return row;
    }

    public int[] getOriginalSelectedRows() {
        int[] rows = this.getSelectedRows();
        int n = rows.length;
        for (int i = 0; i < n; ++i) {
            rows[i] = this.sortModel.convertSortToOriginal(rows[i]);
        }
        return rows;
    }

    public void addOriginalRowSelectionIntervall(int index0, int index1) {
        int min = Math.min(index0, index1);
        int max = Math.max(index0, index1);
        for (int i = min; i <= max; ++i) {
            int index = this.sortModel.convertSortToOriginal(i);
            this.addRowSelectionInterval(index, index);
        }
    }

    public void setResortOnModelChange(boolean resort) {
        this.reactionResort = resort;
    }

    public void setDefaultComparator(Class clazz, Comparator comparator) {
        this.comparators.put(clazz, comparator);
    }

    public Comparator getComparator(int column) {
        return this.getComparator(this.model.getColumnClass(column));
    }

    public Comparator getComparator(Class clazz) {
        Comparator comp = this.internalGetComparator(clazz);
        if (comp == null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            Class<Comparable> comparable = Comparable.class;
            int n = interfaces.length;
            for (int i = 0; i < n; ++i) {
                if (!interfaces[i].equals(comparable)) continue;
                return this.internalGetComparator(comparable);
            }
        }
        return comp;
    }

    private Comparator internalGetComparator(Class clazz) {
        if (clazz != null) {
            Object value = this.comparators.get(clazz);
            if (value == null) {
                return this.internalGetComparator(clazz.getSuperclass());
            }
            return (Comparator)value;
        }
        return null;
    }

    public void setDoNotAlterSortingDirection(boolean doNotAlterSortingDirection) {
        this.doNotAlterSortingDirection = doNotAlterSortingDirection;
    }

    public boolean isDoNotAlterSortingDirection() {
        return this.doNotAlterSortingDirection;
    }

    public boolean isColumnSortable(int column) {
        if (this.model != null) {
            if (this.model instanceof SortableTableModel) {
                return ((SortableTableModel)this.model).isColumnSortable(column);
            }
            return this.getComparator(this.model.getColumnClass(column)) != null;
        }
        return false;
    }

    @Override
    public void setTableHeader(JTableHeader tableHeader) {
        TableCellRenderer renderer;
        if (tableHeader == null) {
            throw new IllegalArgumentException("Header must not be null");
        }
        JTableHeader oldHeader = this.getTableHeader();
        if (oldHeader != null) {
            oldHeader.removeMouseListener(this.listener);
            renderer = oldHeader.getDefaultRenderer();
            if (renderer instanceof SortedTableListener) {
                this.removeSortedTableListener((SortedTableListener)((Object)renderer));
            }
        }
        if ((renderer = tableHeader.getDefaultRenderer()) instanceof SortedTableListener) {
            this.removeSortedTableListener((SortedTableListener)((Object)renderer));
        }
        super.setTableHeader(tableHeader);
        tableHeader.addMouseListener(this.listener);
    }

    public void addSortedTableListener(SortedTableListener listener) {
        if (this.listeners != null) {
            this.listeners.add(listener);
        }
    }

    public void removeSortedTableListener(SortedTableListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireSorted(int column, boolean ascending) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((SortedTableListener)this.listeners.get(i)).sorted(this, column, ascending);
        }
        this.sortModel.fireTableDataChanged();
        this.getTableHeader().repaint();
    }

    protected void fireDesorted() {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((SortedTableListener)this.listeners.get(i)).desorted(this);
        }
        this.getTableHeader().repaint();
    }

    public void desort() {
        this.sortModel.desort();
    }

    protected void createDefaultComparators() {
        this.setDefaultComparator(String.class, Collator.getInstance());
        this.setDefaultComparator(Comparable.class, new ComparableComparator());
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        JTableHeader header = new JTableHeader(super.getColumnModel()){

            @Override
            public void setDefaultRenderer(TableCellRenderer defaultRenderer) {
                TableCellRenderer old = this.getDefaultRenderer();
                if (old instanceof SortedTableListener && SortedTable.this != null) {
                    SortedTable.this.removeSortedTableListener((SortedTableListener)((Object)old));
                }
                DefaultSortTableHeaderRenderer.UIResource renderer = new DefaultSortTableHeaderRenderer.UIResource(defaultRenderer);
                if (SortedTable.this != null) {
                    SortedTable.this.addSortedTableListener(renderer);
                }
                super.setDefaultRenderer(renderer);
            }
        };
        header.setColumnModel(this.getColumnModel());
        return header;
    }

    public void sort(int column, boolean ascendent) {
        this.sortModel.sort(column, ascendent);
    }

    void sizeColumnsOptimal() {
        Object upperRow = null;
        Object lowerRow = null;
        int optimizingColumns = this.getColumnCount();
        int usedWidth = 0;
        for (int index = 0; index < optimizingColumns; ++index) {
            int fromRow = 0;
            int toRow = this.getRowCount();
            usedWidth += this.sizeColumnOptimal(index, fromRow, toRow);
        }
        if (optimizingColumns < this.getColumnCount() && this.getColumnCount() >= 0 && this.getScrollPane() != null && this.getScrollPane().getViewport() != null) {
            int useableWidth = this.getScrollPane().getViewport().getWidth();
            int remainingWidth = Math.max(0, useableWidth - usedWidth);
            TableColumn column = this.getColumnModel().getColumn(this.getColumnCount() - 1);
            column.setPreferredWidth(remainingWidth);
            column.setWidth(remainingWidth);
        }
    }

    public int sizeColumnOptimal(int index, int fromRow, int toRow) {
        TableColumn col = this.getColumnModel().getColumn(index);
        int prefSize = 0;
        prefSize = col.getHeaderRenderer() != null ? col.getHeaderRenderer().getTableCellRendererComponent(null, (Object)col.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width : this.getDefaultRenderer(String.class).getTableCellRendererComponent((JTable)this, (Object)col.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
        for (int rowIndex = fromRow; rowIndex < toRow; ++rowIndex) {
            prefSize = Math.max(prefSize, this.getCellRenderer((int)rowIndex, (int)index).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)rowIndex, (int)index), (boolean)false, (boolean)false, (int)rowIndex, (int)index).getPreferredSize().width);
        }
        col.setPreferredWidth(prefSize += this.getIntercellSpacing().width);
        col.setWidth(prefSize);
        return prefSize;
    }

    public void setScrollPane(JScrollPane sp) {
        this.sp = sp;
    }

    public JScrollPane getScrollPane() {
        return this.sp;
    }

    private class ComparableComparator
    implements Comparator {
        private ComparableComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    }

    private class Model
    extends AbstractTableModel
    implements TableModelListener {
        private Row[] rows = new Row[0];
        private int rowCount = 0;
        private int column = -1;
        private boolean ascendent = false;

        public void sort(int column) {
            if (column == this.column) {
                this.ascendent = !this.ascendent;
                int i = 0;
                for (int j = this.rowCount - 1; i < j; ++i, --j) {
                    Row temp = this.rows[i];
                    this.rows[i] = this.rows[j];
                    this.rows[j] = temp;
                }
                this.fireTableDataChanged();
                SortedTable.this.fireSorted(column, this.ascendent);
            } else if (SortedTable.this.doNotAlterSortingDirection) {
                this.sort(column, this.ascendent);
            } else {
                this.sort(column, true);
            }
        }

        private void resort() {
            this.sort(this.column, this.ascendent);
        }

        public synchronized void sort(int column, boolean ascendent) {
            this.column = column;
            this.ascendent = ascendent;
            if (this.rowCount > 1) {
                Arrays.sort(this.rows, 0, this.rowCount, new RowComparator());
                this.fireTableChanged(new TableModelEvent(this, 0, this.rowCount - 1, -1, 0));
            }
            SortedTable.this.fireSorted(column, ascendent);
        }

        public void desort() {
            this.column = -1;
            SortedTable.this.fireDesorted();
        }

        public synchronized void modelChange(TableModel oldModel, TableModel newModel) {
            if (oldModel != null) {
                oldModel.removeTableModelListener(this);
            }
            newModel.addTableModelListener(this);
            this.ensureAllInArray(newModel);
            this.fireTableStructureChanged();
            this.desort();
        }

        private void ensureAllInArray(TableModel model) {
            int size = model.getRowCount();
            this.ensureRowArray(size);
            for (int i = 0; i < size; ++i) {
                if (this.rows[i] == null) {
                    this.rows[i] = new Row(i);
                    continue;
                }
                this.rows[i].setIndex(i);
            }
            this.rowCount = size;
        }

        private void ensureRowArray(int capacity) {
            if (this.rows.length < capacity) {
                Row[] array = new Row[Math.max(capacity, this.rows.length * 2) + 1];
                System.arraycopy(this.rows, 0, array, 0, this.rowCount);
                this.rows = array;
            }
        }

        public int convertSortToOriginal(int row) {
            return this.rows[row].getIndex();
        }

        public int convertOriginalToSort(int row) {
            for (int i = 0; i < this.rowCount; ++i) {
                if (this.rows[i].getIndex() != row) continue;
                return i;
            }
            return -1;
        }

        public Class getColumnClass(int columnIndex) {
            return SortedTable.this.model.getColumnClass(columnIndex);
        }

        @Override
        public int getColumnCount() {
            if (SortedTable.this.model == null) {
                return 0;
            }
            return SortedTable.this.model.getColumnCount();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return SortedTable.this.model.getColumnName(columnIndex);
        }

        @Override
        public int getRowCount() {
            if (SortedTable.this.model == null) {
                return 0;
            }
            return SortedTable.this.model.getRowCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return SortedTable.this.model.getValueAt(this.rows[rowIndex].getIndex(), columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return SortedTable.this.model.isCellEditable(this.rows[rowIndex].getIndex(), columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            SortedTable.this.model.setValueAt(aValue, this.rows[rowIndex].getIndex(), columnIndex);
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int columns = SortedTable.this.model.getColumnCount();
            if (e.getFirstRow() == -1) {
                this.ensureAllInArray(SortedTable.this.model);
                this.fireTableStructureChanged();
            } else if (e.getType() != 0 || this.rowCount != SortedTable.this.model.getRowCount()) {
                int delta = SortedTable.this.model.getRowCount() - this.rowCount;
                int oldRows = this.rowCount;
                this.ensureAllInArray(SortedTable.this.model);
                if (delta > 0) {
                    this.fireTableRowsInserted(oldRows, SortedTable.this.model.getRowCount() - 1);
                } else if (delta < 0) {
                    this.fireTableRowsDeleted(SortedTable.this.model.getRowCount(), oldRows - 1);
                }
            }
            if (SortedTable.this.reactionResort && this.column >= 0 && this.column < columns) {
                this.resort();
            } else if (this.column != -1) {
                this.desort();
                if (this.rowCount > 0) {
                    this.fireTableRowsUpdated(0, this.rowCount - 1);
                }
            }
        }

        private class RowComparator
        implements Comparator {
            private int columns;
            private Comparator[] comparators;

            public RowComparator() {
                this.columns = SortedTable.this.model.getColumnCount();
                this.comparators = new Comparator[this.columns];
            }

            public int compare(Object o1, Object o2) {
                int result;
                Row a = (Row)o1;
                Row b = (Row)o2;
                if (this.comparators[Model.this.column] == null) {
                    this.comparators[((Model)Model.this).column] = SortedTable.this.getComparator(Model.this.column);
                }
                if ((result = this.compare(this.comparators[Model.this.column], a, b, Model.this.column)) == 0) {
                    for (int index = 0; index < this.columns && result == 0; ++index) {
                        if (index == Model.this.column || !SortedTable.this.isColumnSortable(index)) continue;
                        if (this.comparators[index] == null) {
                            this.comparators[index] = SortedTable.this.getComparator(index);
                        }
                        result = this.compare(this.comparators[index], a, b, index);
                    }
                }
                return result;
            }

            private int compare(Comparator comparator, Row a, Row b, int column) {
                if (Model.this.ascendent) {
                    return comparator.compare(SortedTable.this.model.getValueAt(a.getIndex(), column), SortedTable.this.model.getValueAt(b.getIndex(), column));
                }
                return comparator.compare(SortedTable.this.model.getValueAt(b.getIndex(), column), SortedTable.this.model.getValueAt(a.getIndex(), column));
            }
        }

        private class Row {
            private int index;

            public Row(int index) {
                this.index = index;
            }

            public int getIndex() {
                return this.index;
            }

            public void setIndex(int index) {
                this.index = index;
            }
        }
    }

    private class Listener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            JTableHeader header = (JTableHeader)e.getSource();
            int column = SortedTable.this.convertColumnIndexToModel(header.columnAtPoint(e.getPoint()));
            if (column >= 0 && SortedTable.this.isColumnSortable(column)) {
                SortedTable.this.sortModel.sort(column);
            }
        }
    }
}

