/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.hmi_java_se;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

class MyTableCellRenderer
extends DefaultTableCellRenderer {
    public MyTableCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(table.getForeground());
            super.setBackground(table.getBackground());
        }
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder(border);
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    super.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    super.setBackground(col);
                }
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setFont(table.getFont());
        this.setText(null);
        this.setIcon(null);
        if (value == null) {
            this.setText("null");
        } else if (value instanceof Icon) {
            this.setIcon((Icon)value);
        } else if (value instanceof Color) {
            Color color = (Color)value;
            this.setForeground(color);
            this.setText(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
        } else if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                this.setText("yes");
            } else {
                this.setText("no");
            }
        } else {
            this.setText(value.toString());
        }
        switch (column) {
            case 0: {
                this.setHorizontalAlignment(2);
                break;
            }
            case 1: {
                this.setHorizontalAlignment(2);
                break;
            }
            case 2: {
                this.setHorizontalAlignment(2);
                break;
            }
            case 3: {
                this.setHorizontalAlignment(2);
                break;
            }
            case 4: {
                this.setHorizontalAlignment(2);
                break;
            }
            default: {
                this.setHorizontalAlignment(2);
            }
        }
        if (table.getRowHeight(row) < this.getPreferredSize().height) {
            table.setRowHeight(row, this.getPreferredSize().height);
        }
        return this;
    }
}

