/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.hmi_java_se;

import de.kugihan.dictionaryformids.dataaccess.DictionaryDataFile;
import de.kugihan.dictionaryformids.dataaccess.fileaccess.FileAccessHandler;
import de.kugihan.dictionaryformids.dataaccess.fileaccess.JarInputStreamAccess;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.Util;
import de.kugihan.dictionaryformids.general.UtilWin;
import de.kugihan.dictionaryformids.hmi_common.content.ContentParser;
import de.kugihan.dictionaryformids.hmi_common.content.StringColourItemText;
import de.kugihan.dictionaryformids.hmi_common.content.StringColourItemTextPart;
import de.kugihan.dictionaryformids.hmi_java_se.AWTFileDialog;
import de.kugihan.dictionaryformids.hmi_java_se.DictionarySettings;
import de.kugihan.dictionaryformids.hmi_java_se.MyHeaderCellRenderer;
import de.kugihan.dictionaryformids.hmi_java_se.MyTableCellRenderer;
import de.kugihan.dictionaryformids.hmi_java_se.SortedTable;
import de.kugihan.dictionaryformids.translation.SingleTranslation;
import de.kugihan.dictionaryformids.translation.TextOfLanguage;
import de.kugihan.dictionaryformids.translation.TranslationExecution;
import de.kugihan.dictionaryformids.translation.TranslationExecutionCallback;
import de.kugihan.dictionaryformids.translation.TranslationParameters;
import de.kugihan.dictionaryformids.translation.TranslationResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarFile;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class DictionaryForSE
extends JFrame
implements ActionListener,
TranslationExecutionCallback,
MouseListener,
DocumentListener {
    private static String CONFIG_NAME = "DictionaryForMIDs.ini";
    private JPanel pMainFrame = (JPanel)this.getContentPane();
    private JTextField tfLeft = new JTextField();
    private JTextField tfRight = new JTextField();
    private JLabel lStatus = new JLabel();
    private DefaultTableModel dtm = new DefaultTableModel(){

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                default: 
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    };
    private JTable table = new SortedTable(this.dtm);
    private AWTFileDialog fd = new AWTFileDialog();
    private JMenuBar menuBar = new JMenuBar();
    private JMenu leftLangSubMenu;
    private JMenu rightLangSubMenu;
    private JMenu dictHistoryMenu = new JMenu("Dictionary History");
    private JCheckBoxMenuItem colourTextMenu = new JCheckBoxMenuItem("Coloured Text", true);
    private JPopupMenu pmListL = this.createPopupMenu("L");
    private JPopupMenu pmListR = this.createPopupMenu("R");
    private ButtonGroup bgLeftLang;
    private ButtonGroup bgRightLang;
    private boolean colourText = true;
    private boolean rightSearch = false;
    private boolean configLoaded = false;
    private UtilWin utilObj;
    private Clipboard clip = this.getToolkit().getSystemClipboard();
    private StringSelection cont;
    private Timer timerStatus = new Timer(500, this);
    private Vector dictHistory = new Vector();
    private Vector languages = new Vector();
    private Vector languagesAll = new Vector();
    private String lastSearch = "";
    private String oldStatus = "";
    private Thread searchThread;
    private Properties prop = new Properties();
    public static JarFile jar;
    private JDialog ppd;
    private JButton bUse;
    private JButton bCancelPrefs;
    private JLabel lFontTest;
    private JComboBox cbFont;
    private String fontName = "SansSerif";

    public static void main(String[] args) throws DictionaryException {
        UtilWin utilObj = new UtilWin();
        Util.setUtil(utilObj);
        DictionaryForSE frame = new DictionaryForSE();
        frame.setTitle("DictionaryForMIDs " + Util.getUtil().getApplicationVersionString());
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 400);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public DictionaryForSE() throws DictionaryException {
        this.initGUI();
        this.loadPrefs();
        if (jar == null) {
            this.loadDictionary();
        }
        this.timerStatus.setRepeats(false);
        DictionarySettings.setMaxHits(10000);
        this.fillTableColums();
        this.createGUI();
        TranslationExecution.setTranslationExecutionCallback(this);
        this.lStatus.setText("Welcome to DictionaryForMIDs " + Util.getUtil().getApplicationVersionString() + " (c) by Stefan Martens & Gert Nuber");
    }

    private void initGUI() {
        this.menuBar.add(this.createFileMenu());
        this.menuBar.add(this.createPrefsMenu());
        this.setJMenuBar(this.menuBar);
        this.tfLeft.setToolTipText("Type a search word here and press enter");
        this.tfLeft.addActionListener(this);
        this.tfLeft.addMouseListener(this);
        this.tfLeft.getDocument().addDocumentListener(this);
        this.tfRight.setToolTipText("Type a search word here and press enter");
        this.tfRight.addActionListener(this);
        this.tfRight.addMouseListener(this);
        this.tfRight.getDocument().addDocumentListener(this);
        this.colourTextMenu.addActionListener(this);
        this.table.addMouseListener(this);
        this.table.setSelectionMode(0);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setShowGrid(false);
        this.table.setShowHorizontalLines(true);
        this.table.setAutoResizeMode(4);
        this.table.setDefaultRenderer(String.class, new MyTableCellRenderer());
        ((SortedTable)this.table).setResortOnModelChange(false);
        JTableHeader th = this.table.getTableHeader();
        th.setDefaultRenderer(new MyHeaderCellRenderer());
    }

    private void createGUI() {
        this.pMainFrame.setLayout(new GridBagLayout());
        this.pMainFrame.add((Component)this.tfLeft, this.getGBC(0, 0, 1, 1, 10, 0, new Insets(1, 1, 1, 5)));
        this.pMainFrame.add((Component)this.tfRight, this.getGBC(1, 0, 1, 1, 10, 0, new Insets(1, 5, 1, 1)));
        this.pMainFrame.add((Component)new JScrollPane(this.table), this.getGBC(0, 1, 2, 1, 10, 10, new Insets(1, 1, 1, 1)));
        this.pMainFrame.add((Component)this.lStatus, this.getGBC(0, 2, 2, 1, 10, 0, new Insets(1, 1, 1, 1)));
    }

    private GridBagConstraints getGBC(int gridx, int gridy, int gridwidth, int gridheight, int weightx, int weighty, Insets inset) {
        return new GridBagConstraints(gridx, gridy, gridwidth, gridheight, weightx, weighty, 10, 1, inset, 0, 0);
    }

    private JMenu createFileMenu() {
        JMenu ret = new JMenu("File");
        ret.setMnemonic('F');
        JMenuItem mi = new JMenuItem("Open Dictionary", 111);
        this.setCtrlAccelerator(mi, 'O');
        mi.setActionCommand("openDict");
        mi.addActionListener(this);
        ret.add(mi);
        mi = new JMenuItem("Dictionary Information", 105);
        this.setCtrlAccelerator(mi, 'I');
        mi.setActionCommand("dictInfo");
        mi.addActionListener(this);
        ret.add(mi);
        ret.add(this.createDictHistoryMenu());
        ret.addSeparator();
        mi = new JMenuItem("About", 97);
        mi.setActionCommand("about");
        mi.addActionListener(this);
        ret.add(mi);
        ret.addSeparator();
        mi = new JMenuItem("Quit", 113);
        this.setCtrlAccelerator(mi, 'Q');
        mi.setActionCommand("quit");
        mi.addActionListener(this);
        ret.add(mi);
        return ret;
    }

    private JMenu createPrefsMenu() {
        JMenu ret = new JMenu("Preferences");
        ret.setMnemonic('F');
        JMenuItem mi = new JMenuItem("Change Font", 102);
        this.setCtrlAccelerator(mi, 'F');
        mi.setActionCommand("changeFont");
        mi.addActionListener(this);
        ret.add(mi);
        ret.add(this.colourTextMenu);
        ret.add(this.createLeftLangSubMenu());
        ret.add(this.createRightLangSubMenu());
        ret.addSeparator();
        mi = new JMenuItem("Save Preferences", 115);
        this.setCtrlAccelerator(mi, 'S');
        mi.setActionCommand("savePrefs");
        mi.addActionListener(this);
        ret.add(mi);
        return ret;
    }

    private JMenu createLeftLangSubMenu() {
        this.leftLangSubMenu = new JMenu("Left Language");
        this.bgLeftLang = new ButtonGroup();
        for (int i = 0; i < this.languagesAll.size(); ++i) {
            JRadioButtonMenuItem rbm = new JRadioButtonMenuItem(this.languagesAll.elementAt(i).toString());
            rbm.addActionListener(this);
            rbm.setActionCommand("LangL" + this.languagesAll.elementAt(i).toString());
            this.bgLeftLang.add(rbm);
            this.leftLangSubMenu.add(rbm);
        }
        return this.leftLangSubMenu;
    }

    private JMenu createRightLangSubMenu() {
        this.rightLangSubMenu = new JMenu("Right Language");
        this.bgRightLang = new ButtonGroup();
        for (int i = 0; i < this.languagesAll.size(); ++i) {
            JRadioButtonMenuItem rbm = new JRadioButtonMenuItem(this.languagesAll.elementAt(i).toString());
            rbm.addActionListener(this);
            rbm.setActionCommand("LangR" + this.languagesAll.elementAt(i).toString());
            this.bgRightLang.add(rbm);
            this.rightLangSubMenu.add(rbm);
        }
        return this.rightLangSubMenu;
    }

    private JMenu createDictHistoryMenu() {
        JMenuItem mi;
        this.dictHistoryMenu.removeAll();
        if (this.dictHistory.size() == 0) {
            mi = new JMenuItem("Nothing");
            mi.setEnabled(false);
            this.dictHistoryMenu.add(mi);
        } else {
            for (int i = 0; i < this.dictHistory.size(); ++i) {
                mi = new JMenuItem(this.getMenuFilename(this.dictHistory.elementAt(i).toString()));
                mi.addActionListener(this);
                mi.setActionCommand("HistoryOpen" + this.dictHistory.elementAt(i).toString());
                this.dictHistoryMenu.add(mi);
            }
        }
        this.dictHistoryMenu.addSeparator();
        mi = new JMenuItem("Clear History", 99);
        mi.addActionListener(this);
        mi.setActionCommand("clearHistory");
        this.dictHistoryMenu.add(mi);
        this.dictHistoryMenu.validate();
        return this.dictHistoryMenu;
    }

    private JPopupMenu createPopupMenu(String ident) {
        JPopupMenu pm = new JPopupMenu("Popup");
        JMenuItem mi = new JMenuItem("Copy", 99);
        mi.setActionCommand(ident + "pmCopy");
        mi.addActionListener(this);
        pm.add(mi);
        mi = new JMenuItem("Copy All", 97);
        mi.setActionCommand(ident + "pmCopyAll");
        mi.addActionListener(this);
        pm.add(mi);
        mi = new JMenuItem("Cut");
        mi.setActionCommand(ident + "pmCut");
        mi.addActionListener(this);
        pm.add(mi);
        mi = new JMenuItem("Paste", 112);
        mi.setActionCommand(ident + "pmPaste");
        mi.addActionListener(this);
        pm.add(mi);
        mi = new JMenuItem("Paste & Replace", 112);
        mi.setActionCommand(ident + "pmPasteReplace");
        mi.addActionListener(this);
        pm.add(mi);
        return pm;
    }

    private void setCtrlAccelerator(JMenuItem mi, char acc) {
        KeyStroke ks = KeyStroke.getKeyStroke((int)acc, 2);
        mi.setAccelerator(ks);
    }

    private void fillTableColums() {
        this.deleteTable();
        this.dtm.setColumnCount(0);
        this.dtm.addColumn(this.languages.elementAt(0));
        this.dtm.addColumn(this.languages.elementAt(1));
        this.tfLeft.setEnabled(DictionaryDataFile.supportedLanguages[this.languagesAll.indexOf(this.languages.elementAt((int)0))].isSearchable);
        this.tfRight.setEnabled(DictionaryDataFile.supportedLanguages[this.languagesAll.indexOf(this.languages.elementAt((int)1))].isSearchable);
    }

    private String getMenuFilename(String path) {
        int maxMenuTextLength = 80;
        if (path.length() > maxMenuTextLength) {
            StringBuffer sb = new StringBuffer(path.substring(path.length() - (maxMenuTextLength - 3)));
            sb.insert(0, "...");
            return sb.toString();
        }
        return path;
    }

    private void addTableRow(Vector newRow) {
        try {
            this.dtm.addRow(newRow.toArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteTable() {
        this.dtm.setRowCount(0);
    }

    private void loadDictionary() {
        this.loadDictionary(this.fd.show("Choose DictionaryForMIDs jar file", "LOAD", null, "DictionaryForMIDs.jar"));
    }

    private void loadDictionary(String fileName) {
        if (fileName == null) {
            if (this.languagesAll.size() == 0) {
                this.loadLanguages();
            }
        } else if (DictionaryForSE.loadJar(fileName)) {
            this.utilObj = new UtilWin();
            Util.setUtil(this.utilObj);
            try {
                try {
                    DictionaryDataFile.initValues(false);
                }
                catch (DictionaryException e) {
                    this.showDictInitError();
                }
                this.loadLanguages();
                this.lStatus.setText("Dictionary successfully loaded: " + new File(fileName).getName());
                if (this.configLoaded) {
                    this.saveDictHistory(fileName, false);
                }
            }
            catch (Throwable t) {
                this.loadLanguages();
                this.showDictionaryError(t.toString());
            }
        } else {
            this.showErrorFileNotFound(fileName);
            if (this.languagesAll.size() == 0) {
                this.loadLanguages();
            }
        }
    }

    private void loadLanguages() {
        try {
            this.languagesAll.clear();
            boolean colourSupportNeeded = false;
            for (int language = 0; language < DictionaryDataFile.numberOfAvailableLanguages; ++language) {
                this.languagesAll.addElement(DictionaryDataFile.supportedLanguages[language].languageDisplayText);
                if (!DictionaryDataFile.supportedLanguages[language].contentDefinitionAvailable) continue;
                colourSupportNeeded = true;
            }
            this.colourTextMenu.setEnabled(colourSupportNeeded);
            this.colourText = colourSupportNeeded ? this.colourTextMenu.isSelected() : colourSupportNeeded;
            if (this.languagesAll.size() == 0) {
                this.languagesAll.addElement("N/A");
            }
            this.leftLangSubMenu.removeAll();
            this.rightLangSubMenu.removeAll();
            this.menuBar.remove(1);
            this.menuBar.add(this.createPrefsMenu());
            ((JRadioButtonMenuItem)this.leftLangSubMenu.getItem(0)).setSelected(true);
            ((JRadioButtonMenuItem)this.rightLangSubMenu.getItem(this.rightLangSubMenu.getItemCount() - 1)).setSelected(true);
            this.menuBar.validate();
            this.languages.clear();
            this.languages.addElement(this.languagesAll.elementAt(0));
            this.languages.addElement(this.languagesAll.lastElement());
            DictionarySettings.setInputLanguage(0);
            DictionarySettings.setOutputLanguage(this.createBooleanArray(this.rightLangSubMenu.getItemCount() - 1, this.rightLangSubMenu.getItemCount()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean[] createBooleanArray(int sel, int max) {
        boolean[] retValue = new boolean[max];
        for (int i = 0; i < max; ++i) {
            retValue[i] = i == sel;
        }
        return retValue;
    }

    private String prepareCopy(String text) {
        if (text.startsWith("<html>")) {
            text = text.replaceAll("<br>", System.getProperty("line.separator", "\n"));
            text = text.replaceAll("</?\\b[^>]*>", "");
        }
        return text;
    }

    private void copyToClip() {
        String tmp = null;
        if (this.table.getSelectedRow() != -1) {
            tmp = this.table.getValueAt(this.table.getSelectedRow(), this.table.getSelectedColumn()).toString();
        }
        if (this.copyToClip(tmp = this.prepareCopy(tmp))) {
            this.setStatus(5000, "Selected text \"" + tmp + "\" copied!");
        }
    }

    private boolean copyToClip(String message) {
        if (message != null && message.length() > 0) {
            this.cont = new StringSelection(message);
            this.clip.setContents(this.cont, null);
            return true;
        }
        return false;
    }

    private void setStatus(int time, String text) {
        if (!this.timerStatus.isRunning()) {
            this.oldStatus = this.lStatus.getText();
        }
        this.lStatus.setText(text);
        this.timerStatus.setInitialDelay(time);
        if (this.timerStatus.isRunning()) {
            this.timerStatus.stop();
        }
        this.timerStatus.start();
    }

    private static boolean loadJar(String jarFile) {
        try {
            if (jarFile == null) {
                return false;
            }
            File check = new File(jarFile);
            if (check.exists()) {
                jar = new JarFile(check);
                FileAccessHandler.setDictionaryDataFileISAccess(new JarInputStreamAccess(jar));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void showDictionaryError(String error) {
        JOptionPane.showMessageDialog(this, "You choose an incompatible dictionary!\nPlease make sure that you use an up to date version of DictionaryForMIDs!\nError: " + error, "Error", 2);
    }

    private void showDictInitError() {
        JOptionPane.showMessageDialog(this, "The dictionary uses own programcode and may not work as expected.\nPlease check for an update of the 'DictionaryForMIDs on PC' version!", "Error", 2);
    }

    private void showSearchInProgress() {
        JOptionPane.showMessageDialog(this, "Search is already in progress!", "Information", 1);
    }

    private void showDictInfo() {
        JOptionPane.showMessageDialog(this, DictionaryDataFile.infoText, "Dictionary Information", 1);
    }

    private void showErrorFileNotFound(String path) {
        JOptionPane.showMessageDialog(this, "Dictionary File not found!\n" + path, "Error", 0);
    }

    private void performSearch(String search) {
        this.lastSearch = search;
        this.searchThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DictionaryForSE.this.lStatus.setText("Searching...");
                    boolean[] inputLanguages = new boolean[DictionaryDataFile.numberOfAvailableLanguages];
                    for (int languageCount = 0; languageCount < DictionaryDataFile.numberOfAvailableLanguages; ++languageCount) {
                        inputLanguages[languageCount] = false;
                    }
                    inputLanguages[DictionarySettings.getInputLanguage()] = true;
                    boolean[] outputLanguages = DictionarySettings.getOutputLanguage();
                    TranslationParameters translationParametersObj = new TranslationParameters(DictionaryForSE.this.lastSearch, inputLanguages, outputLanguages, false, DictionarySettings.getMaxHits(), DictionarySettings.getDurationForCancelSearch());
                    TranslationExecution.executeTranslation(translationParametersObj);
                }
                catch (Throwable t) {
                    DictionaryForSE.this.lStatus.setText("Error while searching...");
                    DictionaryForSE.this.showDictionaryError(t.toString());
                }
            }
        });
        this.searchThread.start();
    }

    private void loadPrefs() {
        try {
            this.prop.load(new FileInputStream(CONFIG_NAME));
            this.loadDictionary(this.prop.getProperty("LoadedDictionary"));
            this.fontName = this.prop.getProperty("FontName", this.fontName);
            this.colourText = new Boolean(this.prop.getProperty("ColourText", new Boolean(this.colourText).toString()));
            this.colourTextMenu.setSelected(this.colourText);
            this.languages.clear();
            this.languages.addElement(this.prop.getProperty("InputLanguage"));
            this.languages.addElement(this.prop.getProperty("OutputLanguage"));
            ((JRadioButtonMenuItem)this.leftLangSubMenu.getItem(this.languagesAll.indexOf(this.languages.elementAt(0)))).setSelected(true);
            ((JRadioButtonMenuItem)this.rightLangSubMenu.getItem(this.languagesAll.indexOf(this.languages.elementAt(1)))).setSelected(true);
            this.dictHistory.clear();
            int i = 0;
            while (this.prop.getProperty("DictHistory." + Integer.toString(i)) != null) {
                if (this.prop.getProperty("DictHistory." + Integer.toString(i)).length() > 0) {
                    this.dictHistory.addElement(this.prop.getProperty("DictHistory." + Integer.toString(i)));
                }
                ++i;
            }
            this.deleteDoubleEntries();
            this.createDictHistoryMenu();
            this.changeFonts();
            this.configLoaded = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void savePrefs() {
        try {
            if (jar != null) {
                this.prop.setProperty("LoadedDictionary", jar.getName());
            }
            this.prop.setProperty("FontName", this.fontName);
            this.prop.setProperty("ColourText", new Boolean(this.colourText).toString());
            this.prop.setProperty("InputLanguage", this.languages.elementAt(0).toString());
            this.prop.setProperty("OutputLanguage", this.languages.elementAt(1).toString());
            this.prop.store(new FileOutputStream(CONFIG_NAME, false), "DictionaryForMIDs " + Util.getUtil().getApplicationVersionString());
        }
        catch (Exception e) {
            this.lStatus.setText("Can't save configuration file to disk! Maybe write protected?");
        }
    }

    private void deleteDoubleEntries() {
        int i;
        Vector<String> tmpDB = new Vector<String>();
        for (i = 0; i < this.dictHistory.size(); ++i) {
            tmpDB.addElement(this.dictHistory.elementAt(i).toString().toUpperCase());
        }
        for (i = 0; i < this.dictHistory.size(); ++i) {
            int tmp = tmpDB.indexOf(tmpDB.elementAt(i), i + 1);
            if (tmp == -1) continue;
            tmpDB.removeElementAt(tmp);
            this.dictHistory.removeElementAt(tmp);
            --i;
        }
    }

    private void saveDictHistory(Properties propTmp) {
        for (int i = 0; i < this.dictHistory.size(); ++i) {
            propTmp.setProperty("DictHistory." + Integer.toString(i), this.dictHistory.elementAt(i).toString());
        }
    }

    private void clearDictHistory(Properties propTmp) {
        for (int i = 0; i < this.dictHistory.size(); ++i) {
            propTmp.setProperty("DictHistory." + Integer.toString(i), "");
        }
        this.dictHistory.clear();
    }

    void saveDictHistory(String path, boolean clear) {
        if (path != null) {
            this.dictHistory.insertElementAt(path, 0);
            this.deleteDoubleEntries();
            if (this.dictHistory.size() > 10) {
                this.dictHistory.setSize(10);
            }
        }
        this.prop.clear();
        File checkConfig = new File(CONFIG_NAME);
        if (checkConfig.exists()) {
            try {
                this.prop.load(new FileInputStream(checkConfig));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (clear) {
            this.clearDictHistory(this.prop);
        } else {
            this.saveDictHistory(this.prop);
        }
        try {
            this.prop.store(new FileOutputStream(CONFIG_NAME, false), Util.getUtil().getApplicationVersionString());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.createDictHistoryMenu();
    }

    private void openFontPrefsDialog() {
        String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.ppd = new JDialog(this, "Font Prefs Dialog", true);
        this.ppd.setDefaultCloseOperation(2);
        JPanel ppdRoot = (JPanel)this.ppd.getContentPane();
        this.lFontTest = new JLabel("Demo Text: JDiskDBPro");
        this.bUse = new JButton("Use");
        this.bUse.addActionListener(this);
        this.bCancelPrefs = new JButton("Cancel");
        this.bCancelPrefs.addActionListener(this);
        JToolBar tbBottom = new JToolBar();
        this.cbFont = new JComboBox<String>(fontNames);
        this.cbFont.setSelectedItem(this.fontName);
        this.cbFont.addActionListener(this);
        this.cbFont.setMaximumRowCount(20);
        this.lFontTest.setFont(new Font(this.cbFont.getSelectedItem().toString(), 1, 12));
        tbBottom.setLayout(new FlowLayout());
        tbBottom.setFloatable(false);
        tbBottom.add(this.bUse);
        tbBottom.add(this.bCancelPrefs);
        ppdRoot.setLayout(new BorderLayout());
        ppdRoot.add((Component)this.lFontTest, "North");
        ppdRoot.add((Component)this.cbFont, "Center");
        ppdRoot.add((Component)tbBottom, "South");
        this.ppd.setSize(200, 110);
        this.ppd.setLocationRelativeTo(this);
        this.ppd.setResizable(false);
        this.ppd.setVisible(true);
    }

    private void closeFontPrefsDialog() {
        this.ppd.setVisible(false);
        this.ppd.dispose();
    }

    private void changeFonts() {
        this.tfLeft.setFont(new Font(this.fontName, 0, 12));
        this.tfRight.setFont(new Font(this.fontName, 0, 12));
        this.table.setFont(new Font(this.fontName, 0, 12));
    }

    private String getColouredHTMLText(String text, int languageIndex) {
        try {
            ContentParser cp = new ContentParser();
            StringColourItemText result = cp.determineItemsFromContent(new TextOfLanguage(text, languageIndex), false, false);
            StringBuffer returnString = new StringBuffer();
            String lastColour = null;
            if (this.colourText) {
                returnString.append("<html><nobr>");
            }
            for (int i = 0; i < result.size(); ++i) {
                StringColourItemTextPart part = result.getItemTextPart(i);
                if (this.colourText) {
                    lastColour = part.getColour().getHexValue();
                    returnString.append("<font color=\"");
                    returnString.append(lastColour);
                    returnString.append("\">");
                    switch (part.getStyle().style) {
                        case 3: {
                            returnString.append("<b>");
                            break;
                        }
                        case 4: {
                            returnString.append("<i>");
                            break;
                        }
                        case 2: {
                            returnString.append("<u>");
                        }
                    }
                    returnString.append(part.getText().replaceAll("\n", "</font></nobr><br><nobr><font color=\"" + lastColour + "\">"));
                    switch (part.getStyle().style) {
                        case 3: {
                            returnString.append("</b>");
                            break;
                        }
                        case 4: {
                            returnString.append("</i>");
                            break;
                        }
                        case 2: {
                            returnString.append("</u>");
                        }
                    }
                    returnString.append("</font>");
                    continue;
                }
                returnString.append(part.getText().replaceAll("\n", " - "));
            }
            if (this.colourText) {
                returnString.append("</nobr></html>");
            }
            return returnString.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return text;
        }
    }

    @Override
    public void deletePreviousTranslationResult() {
        this.deleteTable();
    }

    @Override
    public void newTranslationResult(TranslationResult resultOfTranslation) {
        Vector<String> tmp = new Vector<String>();
        if (resultOfTranslation.translationFound()) {
            Enumeration translationsEnum = resultOfTranslation.getAllTranslations();
            while (translationsEnum.hasMoreElements()) {
                tmp.clear();
                SingleTranslation singleTranslation = (SingleTranslation)translationsEnum.nextElement();
                String fromTextString = singleTranslation.getFromText().getText();
                String toTextString = ((TextOfLanguage)singleTranslation.getToTexts().elementAt(0)).getText();
                if (this.rightSearch) {
                    tmp.addElement(this.getColouredHTMLText(toTextString, this.languagesAll.indexOf(this.languages.elementAt(0))));
                    tmp.addElement(this.getColouredHTMLText(fromTextString, this.languagesAll.indexOf(this.languages.elementAt(1))));
                } else {
                    tmp.addElement(this.getColouredHTMLText(fromTextString, this.languagesAll.indexOf(this.languages.elementAt(0))));
                    tmp.addElement(this.getColouredHTMLText(toTextString, this.languagesAll.indexOf(this.languages.elementAt(1))));
                }
                this.addTableRow(tmp);
            }
            this.lStatus.setText(Long.toString(resultOfTranslation.numberOfFoundTranslations()) + " entries found in " + Double.toString((double)resultOfTranslation.executionTime / 1000.0) + " seconds!");
        } else {
            this.lStatus.setText("Nothing found for \"" + this.lastSearch + "\"!");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.tfLeft) {
            DictionarySettings.setInputLanguage(this.languagesAll.indexOf(this.languages.elementAt(0)));
            DictionarySettings.setOutputLanguage(this.createBooleanArray(this.languagesAll.indexOf(this.languages.elementAt(1)), this.languagesAll.size()));
            if (this.searchThread != null) {
                if (this.searchThread.isAlive()) {
                    this.showSearchInProgress();
                } else {
                    this.rightSearch = false;
                    this.performSearch(this.tfLeft.getText());
                }
            } else {
                this.rightSearch = false;
                this.performSearch(this.tfLeft.getText());
            }
            this.tfLeft.selectAll();
        } else if (e.getSource() == this.tfRight) {
            DictionarySettings.setInputLanguage(this.languagesAll.indexOf(this.languages.elementAt(1)));
            DictionarySettings.setOutputLanguage(this.createBooleanArray(this.languagesAll.indexOf(this.languages.elementAt(0)), this.languagesAll.size()));
            if (this.searchThread != null) {
                if (this.searchThread.isAlive()) {
                    this.showSearchInProgress();
                } else {
                    this.rightSearch = true;
                    this.performSearch(this.tfRight.getText());
                }
            } else {
                this.rightSearch = true;
                this.performSearch(this.tfRight.getText());
            }
            this.tfRight.selectAll();
        } else if (e.getSource().equals(this.colourTextMenu)) {
            this.colourText = this.colourTextMenu.isSelected();
        } else if (e.getSource().equals(this.timerStatus)) {
            this.lStatus.setText(this.oldStatus);
        } else if (e.getActionCommand().startsWith("LangL")) {
            DictionarySettings.setInputLanguage(this.languagesAll.indexOf(e.getActionCommand().substring(5)));
            this.languages.setElementAt(e.getActionCommand().substring(5), 0);
            this.fillTableColums();
        } else if (e.getActionCommand().startsWith("LangR")) {
            DictionarySettings.setOutputLanguage(this.createBooleanArray(this.languagesAll.indexOf(e.getActionCommand().substring(5)), this.languagesAll.size()));
            this.languages.setElementAt(e.getActionCommand().substring(5), 1);
            this.fillTableColums();
        } else if (e.getActionCommand().equals("openDict")) {
            this.loadDictionary();
            this.fillTableColums();
        } else if (e.getActionCommand().startsWith("HistoryOpen")) {
            this.loadDictionary(e.getActionCommand().substring(11));
            this.fillTableColums();
        } else if (e.getActionCommand().equals("dictInfo")) {
            this.showDictInfo();
        } else if (e.getActionCommand().equals("about")) {
            try {
                JOptionPane.showMessageDialog(this, "DictionaryForMIDs " + Util.getUtil().getApplicationVersionString() + " (11.02.2007)\n(c) 2005-2007 by Stefan Martens & Gert Nuber\n\nVisit our homepages:\nhttp://dictionarymid.sourceforge.net/\nhttp://www.stefan1200.de", "About", 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (e.getActionCommand().equals("quit")) {
            this.setVisible(false);
            this.dispose();
            System.exit(0);
        } else if (e.getActionCommand().equals("savePrefs")) {
            this.savePrefs();
        } else if (e.getActionCommand().equals("changeFont")) {
            this.openFontPrefsDialog();
        } else if (e.getActionCommand().equals("clearHistory")) {
            this.saveDictHistory(null, true);
        } else if (e.getSource().equals(this.cbFont)) {
            this.lFontTest.setFont(new Font(this.cbFont.getSelectedItem().toString(), 1, 12));
        } else if (e.getSource().equals(this.bUse)) {
            this.fontName = this.cbFont.getSelectedItem().toString();
            this.closeFontPrefsDialog();
            this.changeFonts();
        } else if (e.getSource().equals(this.bCancelPrefs)) {
            this.closeFontPrefsDialog();
        } else if (e.getActionCommand().equals("LpmCopy")) {
            this.tfLeft.copy();
        } else if (e.getActionCommand().equals("RpmCopy")) {
            this.tfRight.copy();
        } else if (e.getActionCommand().equals("LpmCopyAll")) {
            this.copyToClip(this.tfLeft.getText());
        } else if (e.getActionCommand().equals("RpmCopyAll")) {
            this.copyToClip(this.tfRight.getText());
        } else if (e.getActionCommand().equals("LpmCut")) {
            this.tfLeft.cut();
        } else if (e.getActionCommand().equals("RpmCut")) {
            this.tfRight.cut();
        } else if (e.getActionCommand().equals("LpmPaste")) {
            this.tfLeft.paste();
        } else if (e.getActionCommand().equals("RpmPaste")) {
            this.tfRight.paste();
        } else if (e.getActionCommand().equals("LpmPasteReplace")) {
            this.tfLeft.selectAll();
            this.tfLeft.paste();
        } else if (e.getActionCommand().equals("RpmPasteReplace")) {
            this.tfRight.selectAll();
            this.tfRight.paste();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource().equals(this.table)) {
            if (e.isPopupTrigger()) {
                this.copyToClip();
            }
        } else if (e.getSource().equals(this.tfLeft)) {
            if (e.isPopupTrigger()) {
                this.pmListL.show(this.tfLeft, e.getX(), e.getY());
            }
        } else if (e.getSource().equals(this.tfRight) && e.isPopupTrigger()) {
            this.pmListR.show(this.tfRight, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource().equals(this.table)) {
            if (e.isPopupTrigger()) {
                this.copyToClip();
            }
        } else if (e.getSource().equals(this.tfLeft)) {
            if (e.isPopupTrigger()) {
                this.pmListL.show(this.tfLeft, e.getX(), e.getY());
            }
        } else if (e.getSource().equals(this.tfRight) && e.isPopupTrigger()) {
            this.pmListR.show(this.tfRight, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.tfLeft.getDocument() == e.getDocument() || this.tfRight.getDocument() == e.getDocument()) {
            // empty if block
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.tfLeft.getDocument() == e.getDocument() || this.tfRight.getDocument() == e.getDocument()) {
            // empty if block
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

