/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.hmi_java_se;

import de.kugihan.dictionaryformids.hmi_java_se.SortedTable;
import de.kugihan.dictionaryformids.hmi_java_se.SortedTableListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class DefaultSortTableHeaderRenderer
extends JPanel
implements SortedTableListener,
TableCellRenderer {
    private TableCellRenderer renderer;
    private int column = -1;
    private boolean ascending = false;
    private Component image;
    private Icon ascendingIcon;
    private Icon descendingIcon;
    private Icon icon;

    public DefaultSortTableHeaderRenderer(TableCellRenderer renderer) {
        this.renderer = renderer;
        this.ascendingIcon = this.createAscendingIcon();
        this.descendingIcon = this.createDescendingIcon();
        this.setLayout(null);
        this.setOpaque(false);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.image = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.removeAll();
        this.add(this.image);
        if (this.image instanceof JComponent) {
            ((JComponent)this.image).setOpaque(false);
        }
        this.icon = this.column == table.convertColumnIndexToModel(column) ? (this.ascending ? this.ascendingIcon : this.descendingIcon) : null;
        return this;
    }

    @Override
    public void paint(Graphics g) {
        this.image.paint(g);
        if (this.icon != null) {
            int iw = this.icon.getIconWidth();
            int ih = this.icon.getIconHeight();
            int w = this.getWidth();
            int h = this.getHeight();
            Insets insets = new Insets(2, 2, 2, 2);
            if (this.image instanceof Container) {
                insets = ((Container)this.image).getInsets();
            }
            if (this.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
                this.icon.paintIcon(this, g, w - iw - insets.right - 2, (h - ih) / 2);
            } else if (this.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                this.icon.paintIcon(this, g, insets.left, (h - ih) / 2);
            } else {
                this.icon.paintIcon(this, g, w - iw - insets.right - 2, (h - ih) / 2);
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.image.setBounds(0, 0, w, h);
    }

    @Override
    public void update(Graphics g) {
        this.image.update(g);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.image.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.image.getMaximumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.image.getPreferredSize();
    }

    @Override
    public void desorted(SortedTable table) {
        this.column = -1;
    }

    @Override
    public void sorted(SortedTable table, int column, boolean ascending) {
        this.column = column;
        this.ascending = ascending;
    }

    protected Icon createAscendingIcon() {
        return new Icon(){

            @Override
            public int getIconHeight() {
                return 3;
            }

            @Override
            public int getIconWidth() {
                return 5;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(Color.BLACK);
                g.drawLine(x, y + 2, x + 4, y + 2);
                g.drawLine(x + 1, y + 1, x + 3, y + 1);
                g.drawLine(x + 2, y, x + 2, y);
            }
        };
    }

    protected Icon createDescendingIcon() {
        return new Icon(){

            @Override
            public int getIconHeight() {
                return 3;
            }

            @Override
            public int getIconWidth() {
                return 5;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(Color.BLACK);
                g.drawLine(x, y, x + 4, y);
                g.drawLine(x + 1, y + 1, x + 3, y + 1);
                g.drawLine(x + 2, y + 2, x + 2, y + 2);
            }
        };
    }

    public static class UIResource
    extends DefaultSortTableHeaderRenderer
    implements javax.swing.plaf.UIResource {
        public UIResource(TableCellRenderer renderer) {
            super(renderer);
        }
    }
}

