/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.hmi_java_se;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class AppTranslation {
    private String languageDirectory = "Languages";
    private String languageFilePrefix = null;
    private String languageFileSuffix = ".lng";
    private String fileSeparator = System.getProperty("file.separator", "\\");
    private Properties language = new Properties();

    public String getTranslationString(String key, String defaultString) {
        return this.getTranslationStringArray(key, defaultString, null);
    }

    public String getTranslationString(String key, String defaultString, String replace) {
        if (replace == null) {
            return this.getTranslationStringArray(key, defaultString, null);
        }
        String[] replaceArray = new String[]{replace};
        return this.getTranslationStringArray(key, defaultString, replaceArray);
    }

    public String getTranslationStringArray(String key, String defaultString, String[] replace) {
        StringBuffer sb = this.language != null ? new StringBuffer(this.language.getProperty(key, defaultString)) : new StringBuffer(defaultString);
        if (replace == null) {
            return sb.toString();
        }
        int pos = -1;
        for (int i = 0; i < replace.length; ++i) {
            pos = sb.indexOf("%" + Integer.toString(i + 1));
            if (pos == -1) continue;
            sb.replace(pos, pos + 2, replace[i]);
        }
        return sb.toString();
    }

    public boolean loadTranslation() {
        return this.loadTranslation(Locale.getDefault().getDisplayLanguage(Locale.ENGLISH).toLowerCase());
    }

    public boolean loadTranslation(String languageName) {
        boolean retValue = false;
        if (this.language == null) {
            this.language = new Properties();
        }
        this.language.clear();
        try {
            File checkLang = new File(this.languageDirectory + this.fileSeparator + (this.languageFilePrefix == null ? "" : this.languageFilePrefix) + languageName + (this.languageFileSuffix == null ? "" : this.languageFileSuffix));
            if (checkLang.exists()) {
                this.language.load(new FileInputStream(checkLang));
                retValue = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retValue;
    }

    public String getLanguageDirectory() {
        return this.languageDirectory;
    }

    public void setLanguageDirectory(String languageDirectory) {
        this.languageDirectory = languageDirectory;
    }

    public String getLanguageFilePrefix() {
        return this.languageFilePrefix;
    }

    public void setLanguageFilePrefix(String languageFilePrefix) {
        this.languageFilePrefix = languageFilePrefix;
    }

    public String getLanguageFileSuffix() {
        return this.languageFileSuffix;
    }

    public void setLanguageFileSuffix(String languageFileSuffix) {
        this.languageFileSuffix = languageFileSuffix;
    }

    public String[] getAvailableLanguages() {
        File dir = new File(this.getLanguageDirectory());
        String[] dirList = dir.list();
        Vector<String> langList = new Vector<String>();
        int posP = 0;
        int posS = 0;
        for (int i = 0; i < dirList.length; ++i) {
            if (this.getLanguageFilePrefix() == null || !dirList[i].startsWith(this.getLanguageFilePrefix()) || this.getLanguageFileSuffix() == null || !dirList[i].endsWith(this.getLanguageFileSuffix())) continue;
            posP = this.getLanguageFilePrefix() != null ? this.getLanguageFilePrefix().length() : 0;
            posS = this.getLanguageFileSuffix() != null ? dirList[i].length() - this.getLanguageFileSuffix().length() : dirList[i].length() - 1;
            langList.addElement(dirList[i].substring(posP, posS));
        }
        return langList.toArray(new String[0]);
    }
}

