/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.hmi_common.content;

import de.kugihan.dictionaryformids.dataaccess.DictionaryDataFile;
import de.kugihan.dictionaryformids.dataaccess.content.ContentDefinition;
import de.kugihan.dictionaryformids.dataaccess.content.PredefinedContent;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.hmi_common.content.StringColourItemText;
import de.kugihan.dictionaryformids.hmi_common.content.StringColourItemTextPart;
import de.kugihan.dictionaryformids.translation.TextOfLanguage;
import java.util.Stack;

public class ContentParser {
    StringColourItemText stringColourItemText;
    Stack contentHierarchy = new Stack();
    StringBuffer text = new StringBuffer();

    public StringColourItemText determineItemsFromContent(TextOfLanguage contentText, boolean changeInputAndOutputContent, boolean isInput) throws DictionaryException {
        int languageIndex = contentText.getLanguageIndex();
        String contentString = contentText.getText();
        this.stringColourItemText = new StringColourItemText();
        int currentContentNumber = 0;
        ContentDefinition[] contents = DictionaryDataFile.supportedLanguages[languageIndex].contents;
        this.pushNewContent(contents[0], changeInputAndOutputContent, isInput);
        int contentStringLength = contentString.length();
        for (int charCount = 0; charCount < contentStringLength; ++charCount) {
            char contentChar = contentString.charAt(charCount);
            if (DictionaryDataFile.supportedLanguages[languageIndex].contentDefinitionAvailable) {
                if (contentChar == '[') {
                    int contentNumber;
                    if (charCount + 2 >= contentStringLength) {
                        this.throwContentFormatException("Start of content ([) without complete content number");
                    }
                    currentContentNumber = contentNumber = this.getStartContentDigitValue(contentString.charAt(charCount + 1)) * 10 + this.getStartContentDigitValue(contentString.charAt(charCount + 2));
                    charCount += 2;
                    this.addStringColourItemTextPart();
                    if (contentNumber < 1 || contentNumber >= contents.length) {
                        this.throwContentFormatException("Incorrect content number: " + contentNumber);
                    }
                    this.pushNewContent(contents[contentNumber], changeInputAndOutputContent, isInput);
                    continue;
                }
                if (contentChar == ']') {
                    this.addStringColourItemTextPart();
                    this.popContent();
                    continue;
                }
                if (contentChar == '\\') {
                    if (charCount + 1 >= contentStringLength) continue;
                    char nextChar = contentString.charAt(charCount + 1);
                    if (nextChar == '[' || nextChar == ']') {
                        ++charCount;
                        contentChar = nextChar;
                    }
                    this.addText(contentChar);
                    continue;
                }
                this.addText(contentChar);
                continue;
            }
            this.addText(contentChar);
        }
        this.addStringColourItemTextPart();
        return this.stringColourItemText;
    }

    void pushNewContent(ContentDefinition newContent, boolean changeInputAndOutputContent, boolean isInput) throws DictionaryException {
        if (changeInputAndOutputContent && newContent == PredefinedContent.getContentNoDefinitionProvided()) {
            newContent = isInput ? PredefinedContent.getContentInputLanguage() : PredefinedContent.getContentOutputLanguage();
        }
        this.contentHierarchy.push(newContent);
        this.text.setLength(0);
    }

    void popContent() throws DictionaryException {
        this.contentHierarchy.pop();
        if (this.contentHierarchy.isEmpty()) {
            this.throwContentFormatException("End of content without start of content");
        }
    }

    void addText(char contentChar) {
        this.text.append(contentChar);
    }

    void addStringColourItemTextPart() {
        if (this.text.length() > 0) {
            ContentDefinition topContent = this.getTopContent();
            StringColourItemTextPart itemTextPart = this.getItemTextPartFromContent(this.text.toString(), topContent);
            this.stringColourItemText.addItemTextPart(itemTextPart);
        }
        this.text.setLength(0);
    }

    ContentDefinition getTopContent() {
        return (ContentDefinition)this.contentHierarchy.peek();
    }

    StringColourItemTextPart getItemTextPartFromContent(String itemTextPartString, ContentDefinition content) {
        StringColourItemTextPart itemTextPart = new StringColourItemTextPart(itemTextPartString, content.fontColour, content.fontStyle, content.selectionMode);
        return itemTextPart;
    }

    int getStartContentDigitValue(char charParam) throws DictionaryException {
        if (!Character.isDigit(charParam)) {
            this.throwContentFormatException("Start of content ([) is not followed by 2 digits");
        }
        return Character.digit(charParam, 10);
    }

    void throwContentFormatException(String message) throws DictionaryException {
        throw new DictionaryException("Error in content format: " + message);
    }

    public StringBuffer getTextFromStringColourItemText(StringColourItemText stringColourItemText) {
        StringBuffer itemText = new StringBuffer();
        for (int itemTextPartCount = 0; itemTextPartCount < stringColourItemText.size(); ++itemTextPartCount) {
            itemText.append(stringColourItemText.getItemTextPart(itemTextPartCount).getText());
        }
        return itemText;
    }
}

