/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.general;

import de.kugihan.dictionaryformids.dataaccess.DictionaryDataFile;
import de.kugihan.dictionaryformids.dataaccess.fileaccess.FileAccessHandler;
import de.kugihan.dictionaryformids.general.CouldNotOpenPropertyFileException;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.DictionaryInterruptedException;
import de.kugihan.dictionaryformids.general.Properties;
import java.io.IOException;
import java.io.InputStream;

public abstract class Util {
    private static Util utilObj;
    public static final int logLevel0 = 0;
    public static final int logLevel1 = 1;
    public static final int logLevel2 = 2;
    public static final int logLevel3 = 3;
    public static final int logLevelMin = 0;
    public static final int logLevelMax = 3;
    protected int logLevel = 0;
    final String versionNumberPropertyName = "VersionNumber";
    final String versionStatusPropertyName = "VersionStatus";
    final String applicationPropertyFileLocation = "/Application.properties";
    static String applicationVersionString;
    public static final char wildcardAnySeriesOfCharacter = '*';
    public static final char wildcardAnySingleCharacter = '?';
    public static final char noSearchSubExpressionCharacter = '/';
    private Properties dictionaryForMIDsProperties;

    public static Util getUtil() {
        return utilObj;
    }

    public static void setUtil(Util newUtilObj) {
        utilObj = newUtilObj;
    }

    protected abstract void outputMessage(String var1);

    public void log(String logMessage, int logLevelOutput) {
        if (this.logLevel >= logLevelOutput) {
            this.outputMessage(logMessage + "\n");
        }
    }

    public void log(String logMessage) {
        this.log(logMessage, 0);
    }

    public void logDebug(String logMessage) {
        this.log(logMessage, 1);
    }

    public void log(Throwable thrown) {
        if (!(thrown instanceof DictionaryInterruptedException)) {
            this.outputMessage("Thrown " + thrown.toString() + " / " + thrown.getMessage() + "\n");
            thrown.printStackTrace();
        }
    }

    public void logTime(String message, long startTime) {
        long endTime = System.currentTimeMillis();
        long executionTime = endTime - startTime;
        this.log("Time for " + message + ": " + executionTime, 2);
    }

    public void setLogLevel(int logLevelParam) {
        this.logLevel = logLevelParam;
    }

    public static void memCheck(String message) {
        if (Util.getUtil().logLevel > 1) {
            System.gc();
            Util.getUtil().log(message + ": " + String.valueOf(Runtime.getRuntime().freeMemory()));
        }
    }

    public String getApplicationVersionString() throws DictionaryException {
        if (applicationVersionString == null) {
            applicationVersionString = "DfM";
        }
        return applicationVersionString;
    }

    public static boolean isSeparatorCharacter(char character) {
        return Util.charIsLineWhitespace(character) || Util.charIsPunctuation(character);
    }

    public static StringBuffer removePunctuation(StringBuffer string, boolean exceptSearchSpecialCharacters) {
        StringBuffer noPunctuationWord = new StringBuffer();
        for (int charPos = 0; charPos < string.length(); ++charPos) {
            char charFromString = string.charAt(charPos);
            if (!Util.charIsPunctuation(charFromString) || Util.charIsSearchSpecialCharacter(charFromString) && exceptSearchSpecialCharacters) {
                noPunctuationWord.append(charFromString);
                continue;
            }
            noPunctuationWord.append(' ');
        }
        return noPunctuationWord;
    }

    public static StringBuffer convertToLowerCase(StringBuffer string) {
        StringBuffer lowerCaseWord = new StringBuffer();
        for (int charPos = 0; charPos < string.length(); ++charPos) {
            lowerCaseWord.append(Character.toLowerCase(string.charAt(charPos)));
        }
        return lowerCaseWord;
    }

    public static void firstWord(StringBuffer words) {
        for (int charPos = 0; charPos < words.length(); ++charPos) {
            if (!Util.charIsLineWhitespace(words.charAt(charPos)) && !Util.charIsPunctuation(words.charAt(charPos))) continue;
            words.setLength(charPos);
            break;
        }
    }

    public static boolean charIsLineWhitespace(char character) {
        boolean returnValue = character == '\t' || character == ' ';
        return returnValue;
    }

    public static boolean isWhitespace(char character) {
        boolean returnValue = character == '\t' || character == '\n' || character == ' ' || character == '\f' || character == '\u001c' || character == '\u001d' || character == '\u001e' || character == '\u001f';
        return returnValue;
    }

    public static StringBuffer filterSuperflousWhitespaces(StringBuffer expression) {
        int expressionLength = expression.length();
        StringBuffer resultExpression = new StringBuffer(expressionLength);
        boolean lastCharWasWhitespace = false;
        for (int charPos = 0; charPos < expressionLength; ++charPos) {
            char character = expression.charAt(charPos);
            if (Util.charIsLineWhitespace(character)) {
                if (resultExpression.length() != 0 && charPos != expression.length() - 1 && !lastCharWasWhitespace) {
                    resultExpression.append(character);
                }
                lastCharWasWhitespace = true;
                continue;
            }
            resultExpression.append(character);
            lastCharWasWhitespace = false;
        }
        return resultExpression;
    }

    public void convertFieldAndLineSeparatorChars(StringBuffer text) {
        int pos = 0;
        int textlength = text.length();
        while (pos < textlength) {
            char currentCharacter = text.charAt(pos);
            if (currentCharacter == '\\') {
                if (++pos < textlength) {
                    currentCharacter = text.charAt(pos);
                    if (currentCharacter == '\\') {
                        text.deleteCharAt(pos);
                    } else if (currentCharacter == 'n') {
                        text.setCharAt(pos - 1, '\n');
                        text.deleteCharAt(pos);
                    } else if (currentCharacter == 't') {
                        text.setCharAt(pos - 1, '\t');
                        text.deleteCharAt(pos);
                    }
                }
                textlength = text.length();
                continue;
            }
            ++pos;
        }
    }

    public void replaceFieldAndLineSeparatorChars(StringBuffer text) {
        int pos = 0;
        int textlength = text.length();
        while (pos < textlength) {
            char currentCharacter = text.charAt(pos);
            if (currentCharacter == '\\') {
                if (++pos < textlength) {
                    currentCharacter = text.charAt(pos);
                    if (currentCharacter == '\\') {
                        text.deleteCharAt(pos);
                    } else if (currentCharacter == 'n') {
                        text.setCharAt(pos - 1, ' ');
                        text.deleteCharAt(pos);
                    } else if (currentCharacter == 't') {
                        text.setCharAt(pos - 1, ' ');
                        text.deleteCharAt(pos);
                    }
                }
                textlength = text.length();
                continue;
            }
            ++pos;
        }
    }

    static boolean charIsSearchSpecialCharacter(char character) {
        return character == '*' || character == '?';
    }

    public static String removeSuperflousSearchCharacters(String toBeTranslatedWord) {
        StringBuffer result = new StringBuffer(toBeTranslatedWord);
        while (result.length() >= 2) {
            if (result.charAt(0) == '/' && result.charAt(1) == '/') {
                result.deleteCharAt(0);
                continue;
            }
            if (result.charAt(result.length() - 1) != '/' || result.charAt(result.length() - 2) != '/') break;
            result.deleteCharAt(result.length() - 1);
        }
        if (result.length() == 1 && result.charAt(0) == '/') {
            result.deleteCharAt(0);
        }
        int charPos = 0;
        while (result.length() > charPos + 1) {
            if (result.charAt(charPos) == '*' && result.charAt(charPos + 1) == '*') {
                result.deleteCharAt(charPos);
                continue;
            }
            ++charPos;
        }
        return result.toString();
    }

    static boolean charIsPunctuation(char character) {
        String punctuations = "!\"$\u00a7$%&/()=?\u00b4`\\{}[]^\u00b0+*~#'-_.:,;<>|@";
        return punctuations.indexOf(character) != -1;
    }

    public static boolean stringEqualIgnoreCase(String string1, String string2) {
        boolean stringsAreEqual = false;
        if (string1.length() == string2.length()) {
            int pos;
            int stringLength = string1.length();
            for (pos = 0; pos < stringLength && Character.toUpperCase(string1.charAt(pos)) == Character.toUpperCase(string2.charAt(pos)); ++pos) {
            }
            if (pos == stringLength) {
                stringsAreEqual = true;
            }
        }
        return stringsAreEqual;
    }

    public static String[] stringSplit(String stringToSplit, char separatorChar) {
        int numberOfElements = 1;
        int stringToSplitLength = stringToSplit.length();
        for (int charCount = 0; charCount < stringToSplitLength; ++charCount) {
            if (stringToSplit.charAt(charCount) != separatorChar) continue;
            ++numberOfElements;
        }
        String[] stringElements = new String[numberOfElements];
        int elementCount = 0;
        int charLastPos = 0;
        for (int charCount = 0; charCount <= stringToSplitLength; ++charCount) {
            if (charCount != stringToSplitLength && stringToSplit.charAt(charCount) != separatorChar) continue;
            if (charLastPos < stringToSplitLength) {
                stringElements[elementCount] = stringToSplit.substring(charLastPos, charCount);
                charLastPos = charCount + 1;
            } else {
                stringElements[elementCount] = new String("");
            }
            ++elementCount;
        }
        return stringElements;
    }

    public void removeTrailingSlashFromPath(StringBuffer pathname) {
        int length = pathname.length();
        if (pathname.charAt(pathname.length() - 1) == '/') {
            pathname.setLength(length - 1);
        }
    }

    public void openProperties(String propertyPath) throws DictionaryException {
        InputStream propertyStream;
        this.dictionaryForMIDsProperties = new Properties();
        String propertyFileName = propertyPath + DictionaryDataFile.propertyFileName;
        try {
            propertyStream = FileAccessHandler.getDictionaryDataFileISAccess().getInputStream(propertyFileName);
        }
        catch (DictionaryException exception) {
            throw new CouldNotOpenPropertyFileException();
        }
        try {
            this.dictionaryForMIDsProperties.load(propertyStream);
        }
        catch (IOException exception) {
            throw new DictionaryException("Property file could not be read " + DictionaryDataFile.propertyFileName);
        }
    }

    public void closeProperties() throws DictionaryException {
        this.dictionaryForMIDsProperties = null;
    }

    public String getDictionaryProperty(String propertyName) {
        String propertyValue = this.dictionaryForMIDsProperties.getProperty(propertyName);
        if (propertyValue != null) {
            propertyValue = propertyValue.trim();
        }
        return propertyValue;
    }

    public String getDictionaryPropertyString(String propertyName, boolean optional) throws DictionaryException {
        String propertyValue = this.getDictionaryProperty(propertyName);
        if (propertyName != null && propertyName.length() == 0) {
            propertyName = null;
        }
        if (propertyValue == null && !optional) {
            this.propertyNotFound(propertyName);
        }
        return propertyValue;
    }

    public void propertyNotFound(String propertyName) throws DictionaryException {
        String errorText = "Property " + propertyName + " not found";
        throw new DictionaryException(errorText);
    }

    public String getDictionaryPropertyString(String propertyName) throws DictionaryException {
        return this.getDictionaryPropertyString(propertyName, false);
    }

    public int getDictionaryPropertyInt(String propertyName) throws DictionaryException {
        String propertyValue = this.getDictionaryPropertyString(propertyName);
        int propertyValueInt = Integer.valueOf(propertyValue);
        return propertyValueInt;
    }

    public char getDictionaryPropertyChar(String propertyName) throws DictionaryException {
        String propertyValue = this.getDictionaryPropertyString(propertyName);
        char propertyValueChar = this.getCharValueFromProperty(propertyName, propertyValue);
        return propertyValueChar;
    }

    public char getCharValueFromProperty(String propertyName, String propertyValue) throws DictionaryException {
        char propertyValueChar = '\t';
        if (!propertyValue.startsWith("'") || !propertyValue.endsWith("'")) {
            String errorText = "Property " + propertyName + " must start with ' and end with ' ";
            this.log(errorText);
            throw new DictionaryException(errorText);
        }
        String extractedValue = propertyValue.substring(1, propertyValue.length() - 1);
        boolean charPropertyNotWellFormed = false;
        if (extractedValue.startsWith("\\")) {
            if (extractedValue.length() != 2) {
                charPropertyNotWellFormed = true;
            } else if (extractedValue.endsWith("t")) {
                propertyValueChar = '\t';
            } else {
                charPropertyNotWellFormed = true;
            }
        } else if (extractedValue.length() != 1) {
            charPropertyNotWellFormed = true;
        } else {
            propertyValueChar = extractedValue.charAt(0);
        }
        if (charPropertyNotWellFormed) {
            String errorText = "Property " + propertyName + " must contain one character or \\t";
            this.log(errorText);
            throw new DictionaryException(errorText);
        }
        return propertyValueChar;
    }

    public String getDictionaryPropertyStringDefault(String propertyName, String defaultValue) throws DictionaryException {
        String propertyValue = this.getDictionaryPropertyString(propertyName, true);
        String returnValueString = propertyValue != null ? propertyValue : defaultValue;
        return returnValueString;
    }

    public char getDictionaryPropertyCharDefault(String propertyName, char defaultValue) throws DictionaryException {
        String propertyValue = this.getDictionaryPropertyString(propertyName, true);
        char returnValueChar = propertyValue != null ? this.getCharValueFromProperty(propertyName, propertyValue) : defaultValue;
        return returnValueChar;
    }

    public int getDictionaryPropertyIntDefault(String propertyName, int defaultValue) throws DictionaryException {
        String propertyValue = this.getDictionaryPropertyString(propertyName, true);
        int returnValueInt = propertyValue != null ? Integer.valueOf(propertyValue) : defaultValue;
        return returnValueInt;
    }

    public boolean getDictionaryPropertyBooleanDefault(String propertyName, boolean defaultValue) throws DictionaryException {
        String propertyValue = this.getDictionaryPropertyString(propertyName, true);
        boolean returnValueBoolean = propertyValue != null ? this.getBooleanFromProperty(propertyName, propertyValue) : defaultValue;
        return returnValueBoolean;
    }

    public boolean getBooleanFromProperty(String propertyName, String propertyValue) throws DictionaryException {
        boolean returnValueBoolean;
        if (Util.stringEqualIgnoreCase(propertyValue, "true")) {
            returnValueBoolean = true;
        } else if (Util.stringEqualIgnoreCase(propertyValue, "false")) {
            returnValueBoolean = false;
        } else {
            String errorText = "Property " + propertyName + " must be true or false";
            this.log(errorText);
            throw new DictionaryException(errorText);
        }
        return returnValueBoolean;
    }

    public void determineCharEncoding() throws DictionaryException {
    }

    public String getDeviceCharEncoding(String charEncoding) {
        return charEncoding;
    }

    static {
        applicationVersionString = null;
    }
}

