/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.general;

import de.kugihan.dictionaryformids.general.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class Properties
extends Hashtable {
    protected Properties defaults;
    protected String propertyCharEncoding = "ISO-8859-1";
    private static final long serialVersionUID = 4112578634029874840L;
    boolean lastCharacterWasCR = false;

    public Properties() {
        this.propertyCharEncoding = Util.getUtil().getDeviceCharEncoding(this.propertyCharEncoding);
    }

    public Properties(Properties defaults) {
        this.defaults = defaults;
        this.propertyCharEncoding = Util.getUtil().getDeviceCharEncoding(this.propertyCharEncoding);
    }

    public void load(InputStream inStream) throws IOException {
        String line;
        InputStreamReader reader = new InputStreamReader(inStream, this.propertyCharEncoding);
        while ((line = this.readLine(reader)) != null) {
            boolean isDelim;
            int pos;
            char c = '\u0000';
            for (pos = 0; pos < line.length() && Util.isWhitespace(c = line.charAt(pos)); ++pos) {
            }
            if (line.length() - pos == 0 || line.charAt(pos) == '#' || line.charAt(pos) == '!') continue;
            StringBuffer key = new StringBuffer();
            block14: while (pos < line.length() && !Util.isWhitespace(c = line.charAt(pos++)) && c != '=' && c != ':') {
                if (c == '\\') {
                    if (pos == line.length()) {
                        line = this.readLine(reader);
                        for (pos = 0; pos < line.length() && Util.isWhitespace(c = line.charAt(pos)); ++pos) {
                        }
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            key.append('\n');
                            continue block14;
                        }
                        case 't': {
                            key.append('\t');
                            continue block14;
                        }
                        case 'r': {
                            key.append('\r');
                            continue block14;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block14;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            key.append(uni);
                            pos += 4;
                            continue block14;
                        }
                    }
                    key.append(c);
                    continue;
                }
                key.append(c);
            }
            boolean bl = isDelim = c == ':' || c == '=';
            while (pos < line.length() && Util.isWhitespace(c = line.charAt(pos))) {
                ++pos;
            }
            if (!(isDelim || c != ':' && c != '=')) {
                ++pos;
                while (pos < line.length() && Util.isWhitespace(c = line.charAt(pos))) {
                    ++pos;
                }
            }
            StringBuffer element = new StringBuffer(line.length() - pos);
            block18: while (pos < line.length()) {
                if ((c = line.charAt(pos++)) == '\\') {
                    if (pos == line.length()) {
                        line = this.readLine(reader);
                        if (line == null) break;
                        for (pos = 0; pos < line.length() && Util.isWhitespace(c = line.charAt(pos)); ++pos) {
                        }
                        element.ensureCapacity(line.length() - pos + element.length());
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            element.append('\n');
                            continue block18;
                        }
                        case 't': {
                            element.append('\t');
                            continue block18;
                        }
                        case 'r': {
                            element.append('\r');
                            continue block18;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block18;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            element.append(uni);
                            pos += 4;
                            continue block18;
                        }
                    }
                    element.append(c);
                    continue;
                }
                element.append(c);
            }
            this.put(key.toString(), element.toString());
        }
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        Properties prop = this;
        do {
            String value;
            if ((value = (String)prop.get(key)) == null) continue;
            return value;
        } while ((prop = prop.defaults) != null);
        return defaultValue;
    }

    private String readLine(InputStreamReader isr) throws IOException {
        int readValue;
        StringBuffer readLine = new StringBuffer();
        boolean endOfLineReached = false;
        do {
            if ((readValue = isr.read()) == -1) {
                endOfLineReached = true;
                continue;
            }
            char readCharacter = (char)readValue;
            if (readCharacter == '\n') {
                if (!this.lastCharacterWasCR) {
                    endOfLineReached = true;
                }
                this.lastCharacterWasCR = false;
                continue;
            }
            if (readCharacter == '\r') {
                endOfLineReached = true;
                this.lastCharacterWasCR = true;
                continue;
            }
            this.lastCharacterWasCR = false;
            readLine.append(readCharacter);
        } while (!endOfLineReached);
        String readLineReturnValue = readValue == -1 && readLine.length() == 0 ? null : readLine.toString();
        return readLineReturnValue;
    }
}

