/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.dictgen.dictionaryupdate;

import de.kugihan.dictionaryformids.dataaccess.DictionaryDataFile;
import de.kugihan.dictionaryformids.dataaccess.content.ContentLib;
import de.kugihan.dictionaryformids.dictgen.DictionaryGeneration;
import de.kugihan.dictionaryformids.dictgen.dictionaryupdate.DictionaryUpdate;
import de.kugihan.dictionaryformids.dictgen.dictionaryupdate.DictionaryUpdateLib;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.Util;
import java.util.Vector;

public class DictionaryUpdateCEDICTChi
extends DictionaryUpdate {
    final String startDelimiter = "[01";
    final String endDelimiter = "]";

    @Override
    public String updateDictionaryExpression(String dictionaryExpressionParam) throws DictionaryException {
        String updatedExpression;
        String dictionaryExpression = super.updateDictionaryExpression(dictionaryExpressionParam);
        int posStartDelimiter = dictionaryExpression.indexOf("[01");
        int posEndDelimiter = -1;
        if (posStartDelimiter != -1) {
            posEndDelimiter = dictionaryExpression.toString().indexOf("]", posStartDelimiter);
        }
        if (posStartDelimiter != -1 && posEndDelimiter > posStartDelimiter) {
            String pronounciationToneNumbers = dictionaryExpression.substring(posStartDelimiter + "[01".length(), posEndDelimiter);
            StringBuffer pronounciationAccented = new StringBuffer(DictionaryUpdateCEDICTChi.addTones(pronounciationToneNumbers));
            ContentLib.addContentFormat(pronounciationAccented, 1, 0, pronounciationAccented.length() - 1);
            updatedExpression = dictionaryExpression.substring(0, posStartDelimiter) + pronounciationAccented.toString();
        } else {
            updatedExpression = dictionaryExpression;
        }
        return updatedExpression;
    }

    @Override
    public void addKeyWordsSplitUpToKeyWordVector(String expression, Vector keyWordVector) throws DictionaryException {
        String chineseExpression;
        int posStartDelimiter = expression.indexOf("[01");
        int posEndDelimiter = -1;
        if (posStartDelimiter != -1) {
            posEndDelimiter = expression.toString().indexOf("]", posStartDelimiter);
        }
        if (posStartDelimiter != -1 && posEndDelimiter > posStartDelimiter) {
            String pronounciationExpression = expression.substring(posStartDelimiter + "[01".length(), posEndDelimiter);
            chineseExpression = expression.substring(0, posStartDelimiter);
            if (pronounciationExpression.length() > 0) {
                DictionaryUpdateLib.addKeyWordExpressions(pronounciationExpression, keyWordVector);
                String pronounciationWithoutNumbers = this.removeNumbers(pronounciationExpression);
                DictionaryUpdateLib.addKeyWordExpressions(pronounciationWithoutNumbers, keyWordVector);
                String pronounciationAccented = DictionaryUpdateCEDICTChi.addTones(pronounciationExpression);
                DictionaryUpdateLib.addKeyWordExpressions(pronounciationAccented, keyWordVector);
            }
        } else {
            chineseExpression = expression;
        }
        StringBuffer chineseExpressionWithoutContentDelimiters = new StringBuffer(DictionaryGeneration.removeContentDelimiters(chineseExpression, this.indexLanguage));
        Util.filterSuperflousWhitespaces(chineseExpressionWithoutContentDelimiters);
        if (chineseExpressionWithoutContentDelimiters.length() > 0) {
            DictionaryUpdateLib.addKeyWordExpressions(chineseExpressionWithoutContentDelimiters.toString(), keyWordVector);
        }
    }

    @Override
    public String createKeyWordsExpression(String expression) throws DictionaryException {
        String keyWordsExpression = DictionaryDataFile.dictionaryGenerationOmitParFromIndex ? expression : this.updateDictionaryExpression(expression);
        String keyWordsExpressionWithoutContentDelimiters = keyWordsExpression;
        StringBuffer keyWordsExpressionWithoutSeparatorChars = new StringBuffer(keyWordsExpressionWithoutContentDelimiters);
        Util.getUtil().replaceFieldAndLineSeparatorChars(keyWordsExpressionWithoutSeparatorChars);
        String keyWordsCleanedUp = this.removeNonSearchParts(keyWordsExpressionWithoutSeparatorChars.toString());
        return keyWordsCleanedUp;
    }

    protected String removeNumbers(String expression) {
        StringBuffer output = new StringBuffer();
        for (int pos = 0; pos < expression.length(); ++pos) {
            char character = expression.charAt(pos);
            if (Character.isDigit(character)) continue;
            output.append(character);
        }
        return output.toString();
    }

    public static String addTones(String withnumbers) {
        int oldindex;
        int index;
        StringBuffer scratch = new StringBuffer(withnumbers);
        String[] oldtail = new String[]{"ng1", "ng2", "ng3", "ng4", "ng5", "n1", "n2", "n3", "n4", "n5", "r1", "r2", "r3", "r4", "r5", "ao1", "ao2", "ao3", "ao4", "ao5", "ai1", "ai2", "ai3", "ai4", "ao5", "ei1", "ei2", "ei3", "ei4", "ei5", "ou1", "ou2", "ou3", "ou4", "ou5"};
        String[] newtail = new String[]{"1ng", "2ng", "3ng", "4ng", "5ng", "1n", "2n", "3n", "4n", "5n", "1r", "2r", "3r", "4r", "5r", "a1o", "a2o", "a3o", "a4o", "a5o", "a1i", "a2i", "a3i", "a4i", "a5i", "e1i", "e2i", "e3i", "e4i", "e5i", "o1u", "o2u", "o3u", "o4u", "o5u"};
        String[] vowelnums = new String[]{"a1", "a2", "a3", "a4", "a5", "e1", "e2", "e3", "e4", "e5", "i1", "i2", "i3", "i4", "i5", "o1", "o2", "o3", "o4", "o5", "u1", "u2", "u3", "u4", "u5", "u:1", "u:2", "u:3", "u:4", "u:5", "u:", "v1", "v2", "v3", "v4", "v5", "v"};
        String[] voweltones = new String[]{"\u0101", "\u00e1", "\u01ce", "\u00e0", "a", "\u0113", "\u00e9", "\u011b", "\u00e8", "e", "\u012b", "\u00ed", "\u01d0", "\u00ec", "i", "\u014d", "\u00f3", "\u01d2", "\u00f2", "o", "\u016b", "\u00fa", "\u01d4", "\u00f9", "u", "\u01d6", "\u01d8", "\u01da", "\u01dc", "\u00fc", "\u00fc", "\u01d6", "\u01d8", "\u01da", "\u01dc", "\u00fc", "\u00fc"};
        String source = withnumbers = withnumbers.toLowerCase();
        String target = withnumbers;
        for (int i = 0; i < oldtail.length; ++i) {
            index = 0;
            oldindex = 0;
            target = "";
            index = source.indexOf(oldtail[i], oldindex);
            while (index >= 0) {
                target = target + source.substring(oldindex, index);
                target = target + newtail[i];
                oldindex = index + oldtail[i].length();
                index = source.indexOf(oldtail[i], oldindex);
            }
            source = target = target + source.substring(oldindex, source.length());
        }
        boolean foundvowel = false;
        for (int i = 0; i < vowelnums.length; ++i) {
            index = 0;
            oldindex = 0;
            target = "";
            index = source.indexOf(vowelnums[i], oldindex);
            while (index >= 0) {
                target = target + source.substring(oldindex, index);
                target = target + voweltones[i];
                oldindex = index + vowelnums[i].length();
                index = source.indexOf(vowelnums[i], oldindex);
                foundvowel = true;
            }
            source = target = target + source.substring(oldindex, source.length());
        }
        if (!foundvowel) {
            target = withnumbers;
        }
        return target;
    }
}

