/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.dictgen;

import de.kugihan.dictionaryformids.dataaccess.DictionaryDataFile;
import de.kugihan.dictionaryformids.dataaccess.FileCsvFile;
import de.kugihan.dictionaryformids.dataaccess.LanguageDefinition;
import de.kugihan.dictionaryformids.dataaccess.fileaccess.FileAccessHandler;
import de.kugihan.dictionaryformids.dataaccess.fileaccess.FileDfMInputStreamAccess;
import de.kugihan.dictionaryformids.dictgen.IndexKeyWordEntry;
import de.kugihan.dictionaryformids.dictgen.dictionaryupdate.DictionaryUpdate;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.Util;
import de.kugihan.dictionaryformids.general.UtilWin;
import de.kugihan.dictionaryformids.hmi_common.content.ContentParser;
import de.kugihan.dictionaryformids.hmi_common.content.StringColourItemText;
import de.kugihan.dictionaryformids.translation.SearchIndicator;
import de.kugihan.dictionaryformids.translation.TextOfLanguage;
import de.kugihan.dictionaryformids.translation.normation.Normation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class DictionaryGeneration {
    static String FILE_SEPARATOR = System.getProperty("file.separator");
    static String sourceFile;
    static String directoryDestination;
    static String propertyPath;
    static String endOfLineString;
    static long searchListFileMaxSize;
    static long indexFileMaxSize;
    static long dictionaryFileMaxSize;
    static long[] IndexNumberOfSourceEntries;
    static ContentParser contentParserObj;
    private static final char[] weakEncrypt_password;

    public static void main(String[] args) throws DictionaryException {
        UtilWin utilObj = new UtilWin();
        Util.setUtil(utilObj);
        boolean fileAccessError = false;
        DictionaryGeneration.printCopyrightNotice();
        if (args.length != 3) {
            DictionaryGeneration.printArgumentError("Incorrect number of arguments");
            DictionaryGeneration.printUsage();
        } else {
            sourceFile = args[0];
            directoryDestination = args[1];
            propertyPath = args[2];
            if (!directoryDestination.endsWith(DictionaryDataFile.pathNameDataFiles)) {
                DictionaryGeneration.printArgumentError("Argument 2 (outputdirectory) must end with " + DictionaryDataFile.pathNameDataFiles);
                DictionaryGeneration.printUsage();
            } else {
                try {
                    if (!directoryDestination.endsWith(FILE_SEPARATOR)) {
                        directoryDestination = directoryDestination + FILE_SEPARATOR;
                    }
                    if (!propertyPath.endsWith(FILE_SEPARATOR)) {
                        propertyPath = propertyPath + FILE_SEPARATOR;
                    }
                    if (!new File(sourceFile).canRead()) {
                        DictionaryGeneration.printArgumentError("Inputdictionaryfile cannot be accessed: " + sourceFile);
                        fileAccessError = true;
                    }
                    if (!new File(directoryDestination).exists()) {
                        DictionaryGeneration.printArgumentError("Outputdirectory cannot be accessed: " + directoryDestination);
                        fileAccessError = true;
                    }
                    if (!utilObj.readProperties(propertyPath, true)) {
                        System.err.println("Property-file cannot be accessed: " + utilObj.buildPropertyFileName(propertyPath));
                        fileAccessError = true;
                    }
                    if (!fileAccessError) {
                        DictionaryGeneration.generateDictionaryFiles();
                        DictionaryGeneration.copyPropertyFile(utilObj.buildPropertyFileName(propertyPath), directoryDestination);
                        System.out.println("Complete\n");
                    }
                }
                catch (Throwable t) {
                    Util.getUtil().log(t);
                }
            }
        }
    }

    public static void printCopyrightNotice() throws DictionaryException {
        System.out.print("\n\nDictionaryForMIDs/DictionaryGeneration, Copyright (C) 2005, 2006, 2007  Gert Nuber (dict@kugihan.de) et al\nVersion : " + Util.getUtil().getApplicationVersionString() + "\n\n" + "This program comes with ABSOLUTELY NO WARRANTY\n\n" + "This program is free software under the terms and conditions of the GPL " + "(GNU \nGeneral Public License) version 2. See file COPYING. " + "If you did not receive the\nGNU General Public License along with this program " + "(file COPYING), write\nto the Free Software Foundation, Inc., " + "59 Temple Place, Suite 330, Boston,\nMA  02111-1307  USA\n\n" + "Documentation and source code is available from http://dictionarymid.sourceforge.net\n\n\n");
    }

    public static void printUsage() {
        System.out.print("\n\nUsage:\njava -jar DictionaryGeneration.jar inputdictionaryfile outputdirectory propertydirectory\n\ninputdictionaryfile: file from which the directory is read\noutputdirectory: pathname where the generated directory files are written to (must end with \"" + DictionaryDataFile.pathNameDataFiles + "\" !)\n" + "propertydirectory: directory where the file DictionaryForMIDs.properties is located\n\n\n");
    }

    public static void printArgumentError(String errorMessage) {
        System.out.print("\n\nError in command line argument:\n" + errorMessage);
    }

    static void generateDictionaryFiles() throws IOException, DictionaryException {
        String indexString;
        long numberOfEntriesSearchListTotal = 0L;
        long numberOfEntriesIndexTotal = 0L;
        long numberOfEntriesDictionaryTotal = 0L;
        DictionaryGeneration.checkCsvFileFormat(sourceFile);
        System.out.println("Creating: dictionary files");
        FileDfMInputStreamAccess dfmInputStreamObj = new FileDfMInputStreamAccess("");
        FileAccessHandler.setDictionaryDataFileISAccess(dfmInputStreamObj);
        FileCsvFile source = new FileCsvFile(sourceFile, DictionaryDataFile.dictionaryGenerationSeparatorCharacter, DictionaryDataFile.dictionaryGenerationInputCharEncoding);
        String postfixDictionaryFile = new String();
        IndexNumberOfSourceEntries = new long[DictionaryDataFile.numberOfAvailableLanguages];
        boolean generateSeparateDictionaryFile = false;
        HashMap[] indexOfNormatedWords = new HashMap[DictionaryDataFile.numberOfAvailableLanguages];
        contentParserObj = new ContentParser();
        for (int indexLanguage = 0; indexLanguage < DictionaryDataFile.numberOfAvailableLanguages; ++indexLanguage) {
            DictionaryGeneration.IndexNumberOfSourceEntries[indexLanguage] = 0L;
            LanguageDefinition supportedLanguage = DictionaryDataFile.supportedLanguages[indexLanguage];
            if (supportedLanguage.generateIndex) {
                indexOfNormatedWords[indexLanguage] = new HashMap();
                if (supportedLanguage.hasSeparateDictionaryFile) {
                    if (generateSeparateDictionaryFile) {
                        String errorMessage = "More than 1 language with hasSeparateDictionaryFile and generateIndex true";
                        throw new DictionaryException(errorMessage);
                    }
                    generateSeparateDictionaryFile = true;
                    postfixDictionaryFile = supportedLanguage.languageFilePostfix;
                }
            }
            DictionaryUpdate DictionaryUpdateObj = (DictionaryUpdate)DictionaryDataFile.supportedLanguages[indexLanguage].dictionaryUpdateObj;
            DictionaryUpdateObj.setIndexLanguage(indexLanguage);
        }
        String keyWordsDictionaryNonNormated = null;
        long numberOfEntriesInDictionaryFile = 0L;
        long dictionaryFileNumber = 0L;
        long positionInDictionaryFile = 0L;
        String directoryFileName = null;
        Writer destination = null;
        try {
            while (!source.endOfDictionaryReached) {
                String directoryLine = new String();
                if (numberOfEntriesInDictionaryFile >= DictionaryDataFile.dictionaryGenerationMinNumberOfEntriesPerDictionaryFile || destination == null) {
                    ++dictionaryFileNumber;
                    if (destination != null) {
                        DictionaryGeneration.closeFile(destination, directoryFileName);
                        numberOfEntriesInDictionaryFile = 0L;
                        positionInDictionaryFile = 0L;
                    }
                    directoryFileName = new String(DictionaryDataFile.prefixDictionaryFile + postfixDictionaryFile + String.valueOf(dictionaryFileNumber) + DictionaryDataFile.suffixDictionaryFile);
                    directoryFileName = directoryDestination + directoryFileName;
                    destination = new OutputStreamWriter((OutputStream)new FileOutputStream(directoryFileName), DictionaryDataFile.dictionaryCharEncoding);
                }
                for (int indexLanguage = 0; indexLanguage < DictionaryDataFile.numberOfAvailableLanguages; ++indexLanguage) {
                    DictionaryUpdate DictionaryUpdateObj = (DictionaryUpdate)DictionaryDataFile.supportedLanguages[indexLanguage].dictionaryUpdateObj;
                    Normation normationObj = DictionaryDataFile.supportedLanguages[indexLanguage].normationObj;
                    String sourceExpression = source.getWord().toString();
                    keyWordsDictionaryNonNormated = DictionaryUpdateObj.updateDictionaryExpression(sourceExpression);
                    if (DictionaryDataFile.supportedLanguages[indexLanguage].generateIndex) {
                        Vector keyWordVector = DictionaryUpdateObj.createKeyWordVector(sourceExpression, DictionaryDataFile.supportedLanguages[indexLanguage].expressionSplitString);
                        DictionaryUpdateObj.updateKeyWordVector(keyWordVector);
                        for (int indexKeyWord = 0; indexKeyWord < keyWordVector.size(); ++indexKeyWord) {
                            IndexKeyWordEntry indexKeyWordEntryObj = (IndexKeyWordEntry)keyWordVector.elementAt(indexKeyWord);
                            String keyWordNonNormated = indexKeyWordEntryObj.keyWord;
                            SearchIndicator searchIndicatorObj = indexKeyWordEntryObj.searchIndicator;
                            String indexEntryDictionary = normationObj.normateWord(new StringBuffer(keyWordNonNormated), false).toString();
                            if (indexEntryDictionary.length() <= 0) continue;
                            indexString = String.valueOf(dictionaryFileNumber) + DictionaryDataFile.indexFileSeparatorFileNumberToPosition + String.valueOf(positionInDictionaryFile) + DictionaryDataFile.indexFileSeparatorFilePositionToSearchIndicator + searchIndicatorObj.asChar();
                            String existingEntry = (String)indexOfNormatedWords[indexLanguage].get(indexEntryDictionary);
                            if (existingEntry != null) {
                                indexString = existingEntry + DictionaryDataFile.indexFileSeparatorIndexEntries + indexString;
                            }
                            indexOfNormatedWords[indexLanguage].put(indexEntryDictionary, indexString);
                            if (!searchIndicatorObj.isBeginOfExpression()) continue;
                            int n = indexLanguage;
                            IndexNumberOfSourceEntries[n] = IndexNumberOfSourceEntries[n] + 1L;
                        }
                    }
                    directoryLine = directoryLine + keyWordsDictionaryNonNormated;
                    if (indexLanguage >= DictionaryDataFile.numberOfAvailableLanguages - 1) continue;
                    directoryLine = directoryLine + DictionaryDataFile.dictionaryFileSeparationCharacter;
                }
                String directoryOutput = directoryLine + endOfLineString;
                int lengthOfDictionaryEntry = directoryOutput.getBytes(DictionaryDataFile.dictionaryCharEncoding).length;
                if ((positionInDictionaryFile += (long)lengthOfDictionaryEntry) > dictionaryFileMaxSize) {
                    dictionaryFileMaxSize = positionInDictionaryFile;
                }
                if ("weakCrypt".equals(DictionaryDataFile.fileEncodingFormat)) {
                    directoryOutput = DictionaryGeneration.weakEncrypt(directoryOutput);
                }
                destination.write(directoryOutput);
                ++numberOfEntriesDictionaryTotal;
                ++numberOfEntriesInDictionaryFile;
            }
            DictionaryGeneration.closeFile(destination, directoryDestination);
            System.out.println("Done: dictionary files\n");
        }
        catch (DictionaryException e) {
            System.out.println("\n\nError creating line nr. " + (numberOfEntriesDictionaryTotal + 1L) + "\n");
            throw e;
        }
        System.out.println("Creating: index and searchlist files");
        for (int indexLanguage = 0; indexLanguage < DictionaryDataFile.numberOfAvailableLanguages; ++indexLanguage) {
            long numberOfEntriesInIndexFile = 0L;
            long positionInIndexFile = 0L;
            long indexFileNumber = 0L;
            OutputStreamWriter indexFile = null;
            String indexFileName = null;
            if (!DictionaryDataFile.supportedLanguages[indexLanguage].generateIndex) continue;
            String languageFilePostfix = DictionaryDataFile.supportedLanguages[indexLanguage].languageFilePostfix;
            String searchListFileName = directoryDestination + DictionaryDataFile.prefixSearchListFile + languageFilePostfix + DictionaryDataFile.suffixSearchListFile;
            OutputStreamWriter searchListFile = new OutputStreamWriter((OutputStream)new FileOutputStream(searchListFileName), DictionaryDataFile.searchListCharEncoding);
            Set indexSet = new TreeMap(indexOfNormatedWords[indexLanguage]).entrySet();
            for (Map.Entry indexEntry : indexSet) {
                String indexOutput;
                int lengthOfIndexEntry;
                String indexEntryDictionary = (String)indexEntry.getKey();
                indexString = (String)indexEntry.getValue();
                if (numberOfEntriesInIndexFile >= DictionaryDataFile.dictionaryGenerationMinNumberOfEntriesPerIndexFile || indexFile == null) {
                    ++indexFileNumber;
                    if (indexFile != null) {
                        DictionaryGeneration.closeFile(indexFile, indexFileName);
                        numberOfEntriesInIndexFile = 0L;
                    }
                    indexFileName = directoryDestination + DictionaryDataFile.prefixIndexFile + languageFilePostfix + String.valueOf(indexFileNumber) + DictionaryDataFile.suffixIndexFile;
                    indexFile = new OutputStreamWriter((OutputStream)new FileOutputStream(indexFileName), DictionaryDataFile.indexCharEncoding);
                    positionInIndexFile = 0L;
                    String searchListOutput = indexEntryDictionary + DictionaryDataFile.searchListFileSeparationCharacter + String.valueOf(indexFileNumber) + endOfLineString;
                    int lengthOfSearchListEntry = searchListOutput.getBytes(DictionaryDataFile.searchListCharEncoding).length;
                    searchListFileMaxSize += (long)lengthOfSearchListEntry;
                    searchListFile.write(searchListOutput);
                    ++numberOfEntriesSearchListTotal;
                }
                if ((positionInIndexFile += (long)(lengthOfIndexEntry = (indexOutput = indexEntryDictionary + DictionaryDataFile.indexFileSeparationCharacter + indexString + endOfLineString).getBytes(DictionaryDataFile.indexCharEncoding).length)) > indexFileMaxSize) {
                    indexFileMaxSize = positionInIndexFile;
                }
                indexFile.write(indexOutput);
                ++numberOfEntriesIndexTotal;
                ++numberOfEntriesInIndexFile;
            }
            DictionaryGeneration.closeFile(indexFile, indexFileName);
            DictionaryGeneration.closeFile(searchListFile, searchListFileName);
        }
        Util.getUtil().log("Done: index and searchlist files\n\nTotal number of searchlist entries : " + numberOfEntriesSearchListTotal + "\n" + "Total number of index entries :      " + numberOfEntriesIndexTotal + "\n" + "Total number of dictionary entries : " + numberOfEntriesDictionaryTotal + "\n");
    }

    public static void checkCsvFileFormat(String csvFileName) throws DictionaryException, IOException {
        String csvFileLine;
        System.out.println("Checking: " + csvFileName);
        InputStreamReader csvFile = new InputStreamReader((InputStream)new FileInputStream(csvFileName), DictionaryDataFile.dictionaryGenerationInputCharEncoding);
        int lineCounter = 0;
        String splitCharacter = String.valueOf(DictionaryDataFile.dictionaryGenerationSeparatorCharacter);
        while ((csvFileLine = DictionaryGeneration.readLineFromReader(csvFile)) != null) {
            ++lineCounter;
            int numberOfSeparatorCharacters = csvFileLine.split(splitCharacter).length - 1;
            if (numberOfSeparatorCharacters == DictionaryDataFile.numberOfAvailableLanguages - 1) continue;
            System.out.println("\nNumber of separator-characters is not correct in line " + lineCounter);
            System.out.println("\nNumber of found separator-characters: " + numberOfSeparatorCharacters + " / expected: " + (DictionaryDataFile.numberOfAvailableLanguages - 1) + "\n\n");
            throw new DictionaryException("File format incorrect");
        }
        csvFile.close();
        System.out.println("Done: checking\n");
    }

    public static String removeContentDelimiters(String contentString, int indexLanguage) throws DictionaryException {
        StringColourItemText stringColourItemText = contentParserObj.determineItemsFromContent(new TextOfLanguage(contentString, indexLanguage), false, false);
        StringBuffer itemString = contentParserObj.getTextFromStringColourItemText(stringColourItemText);
        return itemString.toString();
    }

    public static String readLineFromReader(InputStreamReader reader) throws IOException {
        int character;
        StringBuffer line = new StringBuffer();
        do {
            if ((character = reader.read()) == -1) {
                return null;
            }
            if (character == 10) continue;
            line.append((char)character);
        } while (character != 10);
        return line.toString();
    }

    public static void copyPropertyFile(String fileNameSourcePropertyFile, String destinationDirectory) {
        String fileNameDestinationPropertyFile = destinationDirectory + "DictionaryForMIDs.properties";
        System.out.println("Creating: " + fileNameDestinationPropertyFile);
        try {
            Properties dictionaryForMIDsProperties = new Properties();
            dictionaryForMIDsProperties.load(new FileInputStream(fileNameSourcePropertyFile));
            DictionaryGeneration.setFileMaxSizeProperty("searchListFileMaxSize", searchListFileMaxSize, dictionaryForMIDsProperties, fileNameSourcePropertyFile);
            DictionaryGeneration.setFileMaxSizeProperty("indexFileMaxSize", indexFileMaxSize, dictionaryForMIDsProperties, fileNameSourcePropertyFile);
            DictionaryGeneration.setFileMaxSizeProperty("dictionaryFileMaxSize", dictionaryFileMaxSize, dictionaryForMIDsProperties, fileNameSourcePropertyFile);
            for (int indexLanguage = 0; indexLanguage < DictionaryDataFile.numberOfAvailableLanguages; ++indexLanguage) {
                long numberOfBeginEntries = IndexNumberOfSourceEntries[indexLanguage];
                if (numberOfBeginEntries <= 0L) continue;
                DictionaryGeneration.setPropertyValue("language" + String.valueOf(indexLanguage + 1) + "IndexNumberOfSourceEntries", String.valueOf(numberOfBeginEntries), dictionaryForMIDsProperties);
            }
            FileOutputStream propertiesDestination = new FileOutputStream(fileNameDestinationPropertyFile);
            dictionaryForMIDsProperties.store(propertiesDestination, "DictionaryForMIDs property file");
        }
        catch (IOException e) {
            Util.getUtil().log(e);
        }
        System.out.println("Done: property file\n");
    }

    public static void setFileMaxSizeProperty(String propertyName, long propertyValue, Properties propertyObj, String fileNamePropertyFile) {
        if (propertyObj.getProperty(propertyName) != null) {
            System.out.println("Property " + propertyName + " exists in " + fileNamePropertyFile + ": not automatically set");
            if (Integer.valueOf(propertyObj.getProperty(propertyName)).longValue() < propertyValue) {
                System.out.println("Warning Property " + propertyName + " should be " + propertyValue);
            }
        } else {
            DictionaryGeneration.setPropertyValue(propertyName, String.valueOf(propertyValue), propertyObj);
        }
    }

    public static void setPropertyValue(String propertyName, String propertyValue, Properties propertyObj) {
        propertyObj.setProperty(propertyName, String.valueOf(propertyValue));
        System.out.println("Property " + propertyName + " set to " + propertyValue);
    }

    public static void closeFile(OutputStreamWriter outFileStream, String fileName) throws IOException {
        outFileStream.close();
    }

    private static String weakEncryptOld(String directoryOutput) {
        StringBuilder res = new StringBuilder(directoryOutput.length());
        for (char ch : directoryOutput.toCharArray()) {
            if (ch >= '<' && ch < '|') {
                ch = (char)((ch - 60 ^ 0x2B) + 60);
            }
            res.append(ch);
        }
        return res.toString();
    }

    private static String weakEncrypt(String word) {
        StringBuilder res = new StringBuilder(word.length());
        int n = 0;
        for (char ch : word.toCharArray()) {
            if (ch >= '<' && ch < '|') {
                ch = (char)(((ch - 60 + weakEncrypt_password[n]) % 64 ^ 0x2B) + 60);
                n = (n + 1) % weakEncrypt_password.length;
            } else {
                n = 0;
            }
            res.append(ch);
        }
        return res.toString();
    }

    static {
        endOfLineString = new String("\n");
        searchListFileMaxSize = 0L;
        indexFileMaxSize = 0L;
        dictionaryFileMaxSize = 0L;
        weakEncrypt_password = "EspernatoEstasBona".toCharArray();
    }
}

