/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.dataaccess.fileaccess;

import de.kugihan.dictionaryformids.dataaccess.fileaccess.DfMInputStreamAccess;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarInputStreamAccess
extends DfMInputStreamAccess {
    protected JarFile jar;

    public JarInputStreamAccess(JarFile jarParam) {
        this.jar = jarParam;
    }

    @Override
    public InputStream getInputStream(String fileName) {
        try {
            fileName = this.buildFileName(fileName);
            ZipEntry tmp = this.jar.getEntry(fileName);
            if (tmp != null) {
                return this.jar.getInputStream(tmp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean fileExists(String fileName) {
        try {
            fileName = this.buildFileName(fileName);
            ZipEntry tmp = this.jar.getEntry(fileName);
            return tmp != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected String buildFileName(String fileName) {
        if (fileName.charAt(0) == '/') {
            fileName = fileName.substring(1);
        }
        return fileName;
    }
}

