/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.dataaccess.content;

import de.kugihan.dictionaryformids.dataaccess.content.ContentDefinition;
import de.kugihan.dictionaryformids.dataaccess.content.FontStyle;
import de.kugihan.dictionaryformids.dataaccess.content.RGBColour;
import de.kugihan.dictionaryformids.dataaccess.content.SelectionMode;
import de.kugihan.dictionaryformids.general.DictionaryException;
import java.util.Hashtable;

public class PredefinedContent {
    public static final FontStyle fontStylePlain = new FontStyle(1);
    public static final FontStyle fontStyleUnderlined = new FontStyle(2);
    public static final FontStyle fontStyleBold = new FontStyle(3);
    public static final FontStyle fontStyleItalic = new FontStyle(4);
    public static final FontStyle fontStyleDefault = fontStylePlain;
    public static final RGBColour fontColourInputLanguage = new RGBColour(0, 0, 80);
    public static final RGBColour fontColourOutputLanguage = new RGBColour(0, 80, 20);
    public static final RGBColour fontColourPronunciation = new RGBColour(0, 128, 0);
    public static final RGBColour fontColourDefault = new RGBColour(0, 0, 0);
    public static SelectionMode selectionModeNone = new SelectionMode(1);
    public static SelectionMode selectionModeSingle = new SelectionMode(2);
    public static SelectionMode selectionModeAll = new SelectionMode(3);
    public static final String backgroundColourDefaultName = "backgroundColourDefault";
    public static final RGBColour backgroundColourDefault = new RGBColour(255, 255, 255);
    private static ContentDefinition contentNoDefinitionProvided;
    private static ContentDefinition contentInputLanguage;
    private static ContentDefinition contentOutputLanguage;
    private static ContentDefinition contentPronunciation;
    public static final String predefinedContentNamePrefix = "content";
    protected static Hashtable predefinedContentMap;

    private static void initPredefinedContent() {
        predefinedContentMap = new Hashtable();
        PredefinedContent.addPredefinedContent("Definition", "UIDisplayTextItems.contentDefault", fontColourDefault, fontStyleDefault, selectionModeNone);
        contentInputLanguage = PredefinedContent.addPredefinedContent("InputLanguage", "UIDisplayTextItems.contentInputLanguage", fontColourInputLanguage, fontStyleBold, selectionModeNone);
        contentOutputLanguage = PredefinedContent.addPredefinedContent("OutputLanguage", "UIDisplayTextItems.contentOutputLanguage", fontColourOutputLanguage, fontStyleDefault, selectionModeNone);
        contentNoDefinitionProvided = PredefinedContent.addPredefinedContent("NoDefinitionProvided", "UIDisplayTextItems.contentNoDefinitionProvided", fontColourDefault, fontStyleDefault, selectionModeNone);
        contentPronunciation = PredefinedContent.addPredefinedContent("Pronunciation", "UIDisplayTextItems.contentPronunciation", fontColourPronunciation, fontStyleDefault, selectionModeNone);
        PredefinedContent.addPredefinedContent("GrammaticalCategory", "UIDisplayTextItems.contentGrammaticalCategory", new RGBColour(128, 0, 0), fontStyleDefault, selectionModeNone);
        PredefinedContent.addPredefinedContent("Notes", "UIDisplayTextItems.contentExplanation", new RGBColour(128, 0, 128), fontStyleDefault, selectionModeNone);
        PredefinedContent.addPredefinedContent("Origin", "UIDisplayTextItems.contentOrigin", new RGBColour(0, 128, 128), fontStyleDefault, selectionModeNone);
        PredefinedContent.addPredefinedContent("SampleUsage", "UIDisplayTextItems.contentSampleUsage", new RGBColour(0, 0, 255), fontStyleDefault, selectionModeNone);
    }

    private static ContentDefinition addPredefinedContent(String contentName, String contentDisplayText, RGBColour fontColour, FontStyle fontStyle, SelectionMode seletionMode) {
        ContentDefinition content = new ContentDefinition(contentDisplayText, fontColour, fontStyle, seletionMode, true);
        predefinedContentMap.put(predefinedContentNamePrefix + contentName, content);
        return content;
    }

    public static void checkInitialization() {
        if (predefinedContentMap == null) {
            PredefinedContent.initPredefinedContent();
        }
    }

    public static ContentDefinition getPredefinedContent(String contentName) throws DictionaryException {
        PredefinedContent.checkInitialization();
        ContentDefinition content = (ContentDefinition)predefinedContentMap.get(contentName);
        if (content == null) {
            throw new DictionaryException("Predefined content not found: " + contentName);
        }
        return content;
    }

    public static ContentDefinition getContentNoDefinitionProvided() {
        PredefinedContent.checkInitialization();
        return contentNoDefinitionProvided;
    }

    public static ContentDefinition getContentInputLanguage() {
        PredefinedContent.checkInitialization();
        return contentInputLanguage;
    }

    public static ContentDefinition getContentOutputLanguage() {
        PredefinedContent.checkInitialization();
        return contentOutputLanguage;
    }

    public static ContentDefinition getContentPronunciation() {
        PredefinedContent.checkInitialization();
        return contentPronunciation;
    }

    static {
        predefinedContentMap = null;
    }
}

