/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.dataaccess;

import de.kugihan.dictionaryformids.dataaccess.DictionaryUpdateIF;
import de.kugihan.dictionaryformids.dataaccess.LanguageDefinition;
import de.kugihan.dictionaryformids.dataaccess.content.ContentDefinition;
import de.kugihan.dictionaryformids.dataaccess.content.FontStyle;
import de.kugihan.dictionaryformids.dataaccess.content.PredefinedContent;
import de.kugihan.dictionaryformids.dataaccess.content.RGBColour;
import de.kugihan.dictionaryformids.dataaccess.content.SelectionMode;
import de.kugihan.dictionaryformids.general.DictionaryClassNotLoadedException;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.Util;
import de.kugihan.dictionaryformids.translation.normation.Normation;

public class DictionaryDataFile {
    public static int numberOfAvailableLanguages;
    public static int numberOfInputLanguages;
    public static LanguageDefinition[] supportedLanguages;
    public static String infoText;
    public static String dictionaryAbbreviation;
    public static String pathNameFonts;
    public static String pathNameDataFiles;
    public static String prefixSearchListFile;
    public static String suffixSearchListFile;
    public static String searchListCharEncoding;
    public static char searchListFileSeparationCharacter;
    public static int searchListFileMaxSize;
    public static String prefixIndexFile;
    public static String suffixIndexFile;
    public static String indexCharEncoding;
    public static char indexFileSeparationCharacter;
    public static char indexFileSeparatorFileNumberToPosition;
    public static char indexFileSeparatorFilePositionToSearchIndicator;
    public static char indexFileSeparatorIndexEntries;
    public static int indexFileMaxSize;
    public static String prefixDictionaryFile;
    public static String suffixDictionaryFile;
    public static String dictionaryCharEncoding;
    public static char dictionaryFileSeparationCharacter;
    public static int dictionaryFileMaxSize;
    public static String applicationFileNamePrefix;
    public static String propertyFileName;
    public static char contentFontColourSeparationCharacter;
    private static RGBColour backgroundColour;
    private static boolean useBackgroundColour;
    public static String dictionaryGenerationInputCharEncoding;
    public static char dictionaryGenerationSeparatorCharacter;
    public static long dictionaryGenerationMinNumberOfEntriesPerDictionaryFile;
    public static long dictionaryGenerationMinNumberOfEntriesPerIndexFile;
    public static boolean dictionaryGenerationOmitParFromIndex;
    public static String fileEncodingFormat;
    public static boolean useStandardPath;
    static /* synthetic */ Class class$de$kugihan$dictionaryformids$translation$normation$Normation;

    public static void initValues(boolean initDictionaryGenerationValues) throws DictionaryException {
        Util utilObj = Util.getUtil();
        utilObj.openProperties(DictionaryDataFile.getPathDataFiles());
        infoText = utilObj.getDictionaryPropertyString("infoText");
        dictionaryAbbreviation = utilObj.getDictionaryPropertyString("dictionaryAbbreviation", true);
        numberOfAvailableLanguages = utilObj.getDictionaryPropertyInt("numberOfAvailableLanguages");
        numberOfInputLanguages = 0;
        supportedLanguages = new LanguageDefinition[numberOfAvailableLanguages];
        for (int indexLanguage = 0; indexLanguage < numberOfAvailableLanguages; ++indexLanguage) {
            String indexLanguageString = String.valueOf(indexLanguage + 1);
            String languagePropertyPrefix = "language" + indexLanguageString;
            String languageDisplayText = utilObj.getDictionaryPropertyString(languagePropertyPrefix + "DisplayText");
            String languageFilePostfix = utilObj.getDictionaryPropertyString(languagePropertyPrefix + "FilePostfix");
            boolean isSearchable = utilObj.getDictionaryPropertyBooleanDefault(languagePropertyPrefix + "IsSearchable", true);
            if (isSearchable) {
                ++numberOfInputLanguages;
            }
            boolean hasSeparateDictionaryFile = utilObj.getDictionaryPropertyBooleanDefault(languagePropertyPrefix + "HasSeparateDictionaryFile", false);
            boolean generateIndex = utilObj.getDictionaryPropertyBooleanDefault(languagePropertyPrefix + "GenerateIndex", true);
            String normationClassName = utilObj.getDictionaryPropertyString(languagePropertyPrefix + "NormationClassName", true);
            String dictionaryUpdateClassName = utilObj.getDictionaryPropertyString(languagePropertyPrefix + "DictionaryUpdateClassName", true);
            int indexNumberOfSourceEntries = utilObj.getDictionaryPropertyIntDefault(languagePropertyPrefix + "IndexNumberOfSourceEntries", -1);
            String expressionSplitString = null;
            if (initDictionaryGenerationValues) {
                expressionSplitString = utilObj.getDictionaryPropertyString("dictionaryGenerationLanguage" + indexLanguageString + "ExpressionSplitString", true);
            }
            String languageIcon = null;
            boolean contentDefinitionAvailable = false;
            ContentDefinition[] content = null;
            int numberOfContentDeclarations = 1;
            String numberOfContentDeclarationsString = utilObj.getDictionaryPropertyString(languagePropertyPrefix + "NumberOfContentDeclarations", true);
            if (numberOfContentDeclarationsString != null) {
                numberOfContentDeclarations = Integer.valueOf(numberOfContentDeclarationsString) + 1;
                contentDefinitionAvailable = true;
            }
            content = new ContentDefinition[numberOfContentDeclarations];
            content[0] = PredefinedContent.getContentNoDefinitionProvided();
            for (int indexContent = 0; indexContent < numberOfContentDeclarations; ++indexContent) {
                String selectionModeString;
                String displaySelectablePropertyName;
                String displaySelectableString;
                String fontStyleString;
                String indexContentString = String.valueOf(indexContent);
                if (indexContentString.length() == 1) {
                    indexContentString = '0' + indexContentString;
                } else if (indexContentString.length() > 2) {
                    throw new DictionaryException("Number of contents too big");
                }
                String contentPropertyPrefix = languagePropertyPrefix + "Content" + indexContentString;
                String contentDisplayTextProperty = contentPropertyPrefix + "DisplayText";
                String contentDisplayText = utilObj.getDictionaryPropertyString(contentDisplayTextProperty, true);
                if (contentDisplayText == null) {
                    if (indexContent == 0) continue;
                    utilObj.propertyNotFound(contentDisplayTextProperty);
                }
                ContentDefinition contentFromPropertyFile = contentDisplayText.startsWith("content") ? PredefinedContent.getPredefinedContent(contentDisplayText) : new ContentDefinition(contentDisplayText);
                String fontColourString = utilObj.getDictionaryPropertyString(contentPropertyPrefix + "FontColour", true);
                if (fontColourString != null) {
                    RGBColour fontColour = DictionaryDataFile.determineRGBColourFromProperty(fontColourString, contentPropertyPrefix);
                    contentFromPropertyFile.setFontColour(fontColour);
                }
                if ((fontStyleString = utilObj.getDictionaryPropertyString(contentPropertyPrefix + "FontStyle", true)) != null) {
                    FontStyle fontStyle = null;
                    if (Util.stringEqualIgnoreCase(fontStyleString, "plain")) {
                        fontStyle = PredefinedContent.fontStylePlain;
                    } else if (Util.stringEqualIgnoreCase(fontStyleString, "underlined")) {
                        fontStyle = PredefinedContent.fontStyleUnderlined;
                    } else if (Util.stringEqualIgnoreCase(fontStyleString, "bold")) {
                        fontStyle = PredefinedContent.fontStyleBold;
                    } else if (Util.stringEqualIgnoreCase(fontStyleString, "italic")) {
                        fontStyle = PredefinedContent.fontStyleItalic;
                    } else {
                        DictionaryDataFile.throwContentException("Incorrect font style", contentPropertyPrefix);
                    }
                    contentFromPropertyFile.setFontStyle(fontStyle);
                }
                if ((displaySelectableString = utilObj.getDictionaryPropertyString(displaySelectablePropertyName = new String(contentPropertyPrefix + "DisplaySelectable"), true)) != null) {
                    boolean displaySelectable = utilObj.getBooleanFromProperty(displaySelectablePropertyName, displaySelectableString);
                    contentFromPropertyFile.setDisplaySelectable(displaySelectable);
                }
                if ((selectionModeString = utilObj.getDictionaryPropertyString(contentPropertyPrefix + "SelectionMode", true)) != null) {
                    SelectionMode selectionMode = null;
                    if (Util.stringEqualIgnoreCase(selectionModeString, "none")) {
                        selectionMode = PredefinedContent.selectionModeNone;
                    } else if (Util.stringEqualIgnoreCase(selectionModeString, "single")) {
                        selectionMode = PredefinedContent.selectionModeSingle;
                    } else if (Util.stringEqualIgnoreCase(selectionModeString, "all")) {
                        selectionMode = PredefinedContent.selectionModeAll;
                    } else {
                        DictionaryDataFile.throwContentException("Incorrect selection mode", contentPropertyPrefix);
                    }
                    contentFromPropertyFile.setSelectionMode(selectionMode);
                }
                content[indexContent] = contentFromPropertyFile;
            }
            DictionaryDataFile.supportedLanguages[indexLanguage] = new LanguageDefinition(languageDisplayText, languageFilePostfix, isSearchable, hasSeparateDictionaryFile, normationClassName, indexNumberOfSourceEntries, contentDefinitionAvailable, content, dictionaryUpdateClassName, generateIndex, expressionSplitString, languageIcon);
        }
        searchListCharEncoding = utilObj.getDictionaryPropertyString("searchListCharEncoding");
        searchListCharEncoding = utilObj.getDeviceCharEncoding(searchListCharEncoding);
        searchListFileSeparationCharacter = utilObj.getDictionaryPropertyChar("searchListFileSeparationCharacter");
        searchListFileMaxSize = utilObj.getDictionaryPropertyIntDefault("searchListFileMaxSize", 10000);
        indexCharEncoding = utilObj.getDictionaryPropertyString("indexCharEncoding");
        indexCharEncoding = utilObj.getDeviceCharEncoding(indexCharEncoding);
        indexFileSeparationCharacter = utilObj.getDictionaryPropertyChar("indexFileSeparationCharacter");
        indexFileMaxSize = utilObj.getDictionaryPropertyIntDefault("indexFileMaxSize", 10000);
        dictionaryCharEncoding = utilObj.getDictionaryPropertyString("dictionaryCharEncoding");
        dictionaryCharEncoding = utilObj.getDeviceCharEncoding(dictionaryCharEncoding);
        dictionaryFileSeparationCharacter = utilObj.getDictionaryPropertyChar("dictionaryFileSeparationCharacter");
        dictionaryFileMaxSize = utilObj.getDictionaryPropertyIntDefault("dictionaryFileMaxSize", 10000);
        String backgroundColourProperty = "backgroundColour";
        String backgroundColourString = utilObj.getDictionaryPropertyString(backgroundColourProperty, true);
        if (backgroundColourString == null) {
            DictionaryDataFile.setUseBackgroundColour(false);
            DictionaryDataFile.setBackgroundColour(null);
        } else {
            DictionaryDataFile.setUseBackgroundColour(true);
            if (Util.stringEqualIgnoreCase(backgroundColourString, "backgroundColourDefault")) {
                DictionaryDataFile.setBackgroundColour(PredefinedContent.backgroundColourDefault);
            } else {
                DictionaryDataFile.setBackgroundColour(DictionaryDataFile.determineRGBColourFromProperty(backgroundColourString, backgroundColourProperty));
            }
        }
        if (initDictionaryGenerationValues) {
            dictionaryGenerationInputCharEncoding = utilObj.getDictionaryPropertyStringDefault("dictionaryGenerationInputCharEncoding", "ISO-8859-1");
            dictionaryGenerationSeparatorCharacter = utilObj.getDictionaryPropertyCharDefault("dictionaryGenerationSeparatorCharacter", '\t');
            dictionaryGenerationMinNumberOfEntriesPerDictionaryFile = utilObj.getDictionaryPropertyIntDefault("dictionaryGenerationMinNumberOfEntriesPerDictionaryFile", 200);
            dictionaryGenerationMinNumberOfEntriesPerIndexFile = utilObj.getDictionaryPropertyIntDefault("dictionaryGenerationMinNumberOfEntriesPerIndexFile", 500);
            dictionaryGenerationOmitParFromIndex = utilObj.getDictionaryPropertyBooleanDefault("dictionaryGenerationOmitParFromIndex", true);
        }
        if ((fileEncodingFormat = utilObj.getDictionaryPropertyString("fileEncodingFormat", true)) == null) {
            fileEncodingFormat = new String("plain_format1");
        }
        for (int indexLanguage = 0; indexLanguage < numberOfAvailableLanguages; ++indexLanguage) {
            DictionaryUpdateIF dictionaryUpdateObj;
            Normation normationObj;
            String normationClassName = DictionaryDataFile.supportedLanguages[indexLanguage].normationClassName;
            DictionaryDataFile.supportedLanguages[indexLanguage].normationObj = normationObj = (Normation)DictionaryDataFile.getObjectForClass(normationClassName, (class$de$kugihan$dictionaryformids$translation$normation$Normation == null ? DictionaryDataFile.class$("de.kugihan.dictionaryformids.translation.normation.Normation") : class$de$kugihan$dictionaryformids$translation$normation$Normation).getName(), "de.kugihan.dictionaryformids.translation.normation", "de.kugihan.dictionaryformids.translation");
            if (!initDictionaryGenerationValues) continue;
            String dictionaryUpdateClassName = DictionaryDataFile.supportedLanguages[indexLanguage].dictionaryUpdateClassName;
            DictionaryDataFile.supportedLanguages[indexLanguage].dictionaryUpdateObj = dictionaryUpdateObj = (DictionaryUpdateIF)DictionaryDataFile.getObjectForClass(dictionaryUpdateClassName, "de.kugihan.dictionaryformids.dictgen.dictionaryupdate.DictionaryUpdate", "de.kugihan.dictionaryformids.dictgen.dictionaryupdate", "de.kugihan.dictionaryformids.dictgen");
        }
    }

    protected static Object getObjectForClass(String className, String fallbackClassName, String newPackageName, String oldPackageName) throws DictionaryException {
        Object classObj;
        if (className == null) {
            className = fallbackClassName;
        }
        try {
            Class<?> classToLoad = Class.forName(className);
            classObj = classToLoad.newInstance();
        }
        catch (Exception e) {
            try {
                StringBuffer classNameNewPackage = new StringBuffer(className);
                classNameNewPackage.delete(0, oldPackageName.length());
                String classNameNewPackageStr = newPackageName + classNameNewPackage.toString();
                Class<?> classToLoad = Class.forName(classNameNewPackageStr);
                classObj = classToLoad.newInstance();
            }
            catch (Exception e2) {
                throw new DictionaryClassNotLoadedException("Class could not be loaded: " + className);
            }
        }
        return classObj;
    }

    public static int determineColourComponent(String rbgString, String propertyName) throws DictionaryException {
        String rbgStringTrimmed = rbgString.trim();
        int rgbValue = 0;
        try {
            rgbValue = Integer.parseInt(rbgStringTrimmed);
        }
        catch (NumberFormatException e) {
            DictionaryDataFile.throwContentException("RGB value is incorrect: " + e.getMessage(), propertyName);
        }
        if (rgbValue > 255) {
            DictionaryDataFile.throwContentException("RGB value is bigger than 255", propertyName);
        }
        return rgbValue;
    }

    protected static RGBColour determineRGBColourFromProperty(String fontColourString, String propertyName) throws DictionaryException {
        String[] fontColourStringElements = Util.stringSplit(fontColourString, contentFontColourSeparationCharacter);
        if (fontColourStringElements.length != 3) {
            DictionaryDataFile.throwContentException("3 components reqired for font colour (red, green, blue)", propertyName);
        }
        int red = DictionaryDataFile.determineColourComponent(fontColourStringElements[0], propertyName);
        int green = DictionaryDataFile.determineColourComponent(fontColourStringElements[1], propertyName);
        int blue = DictionaryDataFile.determineColourComponent(fontColourStringElements[2], propertyName);
        return new RGBColour(red, green, blue);
    }

    public static String getDisplayText(String propertyName) throws DictionaryException {
        String displayText;
        Util utilObj = Util.getUtil();
        String displayTextString = utilObj.getDictionaryPropertyString(propertyName, true);
        if (displayTextString != null) {
            if (displayTextString.charAt(0) != '\"' || displayTextString.charAt(displayTextString.length() - 1) != '\"') {
                DictionaryDataFile.throwContentException("String must start with \" and end with \"", propertyName);
            }
            if ((displayText = displayTextString.substring(1, displayTextString.length() - 1)).indexOf(34) != -1) {
                DictionaryDataFile.throwContentException("String must not contain a \"-character", propertyName);
            }
        } else {
            displayText = null;
        }
        return displayText;
    }

    protected static void throwContentException(String message, String propertyName) throws DictionaryException {
        throw new DictionaryException(propertyName + ": " + message);
    }

    public static void setDictionaryNotAvailable() {
        numberOfAvailableLanguages = 0;
    }

    public static String getPathDataFiles() {
        if (useStandardPath) {
            return "/" + pathNameDataFiles + "/";
        }
        return "";
    }

    public static String getDfMPropertyFileLocation(String dfmBaseDirectory) {
        return dfmBaseDirectory.toString() + DictionaryDataFile.getPathDataFiles() + propertyFileName;
    }

    public static RGBColour getBackgroundColour() {
        return backgroundColour;
    }

    public static void setBackgroundColour(RGBColour backgroundColour) {
        DictionaryDataFile.backgroundColour = backgroundColour;
    }

    public static boolean isUseBackgroundColour() {
        return useBackgroundColour;
    }

    public static void setUseBackgroundColour(boolean useBackgroundColour) {
        DictionaryDataFile.useBackgroundColour = useBackgroundColour;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        pathNameFonts = "fonts";
        pathNameDataFiles = "dictionary";
        prefixSearchListFile = "searchlist";
        suffixSearchListFile = ".csv";
        prefixIndexFile = "index";
        suffixIndexFile = ".csv";
        indexFileSeparatorFileNumberToPosition = (char)45;
        indexFileSeparatorFilePositionToSearchIndicator = (char)45;
        indexFileSeparatorIndexEntries = (char)44;
        prefixDictionaryFile = "directory";
        suffixDictionaryFile = ".csv";
        applicationFileNamePrefix = "DictionaryForMIDs";
        propertyFileName = applicationFileNamePrefix + ".properties";
        contentFontColourSeparationCharacter = (char)44;
        useStandardPath = true;
    }
}

