/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.dataaccess;

import de.kugihan.dictionaryformids.dataaccess.CsvFile;
import de.kugihan.dictionaryformids.dataaccess.fileaccess.FileAccessHandler;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.Util;
import java.io.IOException;
import java.io.InputStream;

class CsvFileCache {
    protected InputStream cachedFile = null;
    protected String fileName = null;
    protected int lastPositionInStream;

    CsvFileCache() {
    }

    synchronized InputStream getCsvFile(String fileNameParam, int startPosition, CsvFile csvFileObj) throws IOException, DictionaryException {
        long startTime = System.currentTimeMillis();
        InputStream csvStream = null;
        if (this.cachedFile != null && this.fileName.equals(fileNameParam)) {
            System.out.println("cache hit " + fileNameParam);
            int numberOfBytesToBeSkipped = startPosition - this.lastPositionInStream;
            if (numberOfBytesToBeSkipped < 0) {
                FileAccessHandler.getDictionaryDataFileISAccess().getInputStream(fileNameParam);
                numberOfBytesToBeSkipped = startPosition;
            } else {
                this.cachedFile.reset();
            }
            long skippedBytes = this.cachedFile.skip(numberOfBytesToBeSkipped);
            if (skippedBytes != (long)numberOfBytesToBeSkipped) {
                throw new DictionaryException("CSV file: skipped only " + skippedBytes + " bytes");
            }
            this.lastPositionInStream = startPosition;
            csvStream = this.cachedFile;
        } else {
            this.fileName = fileNameParam;
            this.lastPositionInStream = startPosition;
            if (this.cachedFile != null) {
                this.cachedFile.close();
            }
            csvStream = FileAccessHandler.getDictionaryDataFileISAccess().getInputStream(this.fileName);
            Util.getUtil().logTime("open file", startTime);
            startTime = System.currentTimeMillis();
            if (csvStream != null) {
                long skippedBytes = csvStream.skip(startPosition);
                Util.getUtil().logTime("position file", startTime);
                if (skippedBytes != (long)startPosition) {
                    throw new DictionaryException("CSV file: skipped only " + skippedBytes + " bytes");
                }
            } else {
                throw new DictionaryException("Could not open file " + this.fileName);
            }
        }
        return csvStream;
    }
}

