/*
 * Decompiled with CFR 0.152.
 */
package de.kugihan.dictionaryformids.dataaccess;

import de.kugihan.dictionaryformids.dataaccess.CsvFileCache;
import de.kugihan.dictionaryformids.dataaccess.fileaccess.FileAccessHandler;
import de.kugihan.dictionaryformids.general.DictionaryException;
import de.kugihan.dictionaryformids.general.DictionaryInterruptedException;
import de.kugihan.dictionaryformids.general.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;

public class CsvFile {
    public static boolean selectedBypassCharsetDecoding = false;
    public boolean endOfDictionaryReached = false;
    protected fileStorage fileStorageObj;
    protected int position = 0;
    protected int columnNumber = 0;
    protected char separatorCharacter;
    protected String fileName;
    protected int maxSizeOfFileData;
    protected String charEncoding;
    static CsvFileCache fileCache = new CsvFileCache();

    public CsvFile(String fileNameParam, char separatorCharacterParam, String charEncodingParam, int maxSizeOfFileDataParam) throws DictionaryException {
        this.setParams(fileNameParam, separatorCharacterParam, charEncodingParam, maxSizeOfFileDataParam);
        this.readCsvFileComplete();
    }

    public CsvFile(String fileNameParam, char separatorCharacterParam, String charEncodingParam, int maxSizeOfFileDataParam, int startPositionParam) throws DictionaryException {
        this.setParams(fileNameParam, separatorCharacterParam, charEncodingParam, maxSizeOfFileDataParam);
        this.readCsvFileLine(startPositionParam);
    }

    private void setParams(String fileNameParam, char separatorCharacterParam, String charEncodingParam, int maxSizeOfFileDataParam) {
        this.separatorCharacter = separatorCharacterParam;
        this.charEncoding = charEncodingParam;
        this.maxSizeOfFileData = maxSizeOfFileDataParam;
        this.fileName = fileNameParam;
    }

    public void readCsvFileComplete() throws DictionaryException {
        byte[] fileData = new byte[this.maxSizeOfFileData];
        try {
            int sizeOfFile;
            long startTime = System.currentTimeMillis();
            InputStream csvStream = FileAccessHandler.getDictionaryDataFileISAccess().getInputStream(this.fileName);
            Util.getUtil().logTime("open file", startTime);
            startTime = System.currentTimeMillis();
            if (csvStream != null) {
                int bytesRead;
                sizeOfFile = 0;
                do {
                    if ((bytesRead = csvStream.read(fileData, sizeOfFile, fileData.length - sizeOfFile)) != -1) {
                        sizeOfFile += bytesRead;
                    }
                    if (sizeOfFile != fileData.length) continue;
                    int character = csvStream.read();
                    if (character == -1) break;
                    Util.getUtil().log("Warning: buffer size too small for file " + this.fileName);
                    break;
                } while (bytesRead != -1);
            } else {
                throw new DictionaryException("Could not open file " + this.fileName);
            }
            csvStream.close();
            Util.getUtil().logTime("read file", startTime);
            startTime = System.currentTimeMillis();
            this.fileStorageObj = selectedBypassCharsetDecoding ? new byteFileStorage(fileData, sizeOfFile) : new stringFileStorage(fileData, sizeOfFile, this.charEncoding);
            Util.getUtil().logTime("parse file", startTime);
        }
        catch (InterruptedIOException e) {
            throw new DictionaryInterruptedException(e);
        }
        catch (IOException e) {
            throw new DictionaryException(e);
        }
    }

    public void readCsvFileLine(int startPosition) throws DictionaryException {
        if (!selectedBypassCharsetDecoding) {
            try {
                InputStream csvStream = fileCache.getCsvFile(this.fileName, startPosition, this);
                long startTime = System.currentTimeMillis();
                int sizeOfFile = 0;
                StringBuffer csvLineString = new StringBuffer();
                InputStreamReader csvStreamReader = new InputStreamReader(csvStream, this.charEncoding);
                boolean endOfLineReached = false;
                do {
                    int character;
                    if ((character = csvStreamReader.read()) != 10 && character != -1) {
                        csvLineString.append((char)character);
                        ++sizeOfFile;
                        continue;
                    }
                    endOfLineReached = true;
                } while (!endOfLineReached);
                Util.getUtil().logTime("read/parse file-line", startTime);
                this.fileStorageObj = new stringFileStorage(csvLineString);
            }
            catch (InterruptedIOException e) {
                throw new DictionaryInterruptedException(e);
            }
            catch (IOException e) {
                throw new DictionaryException(e);
            }
        } else {
            this.readCsvFileComplete();
            this.setPosition(startPosition);
        }
    }

    public void setPosition(int newPosition) {
        this.position = newPosition;
    }

    public final void skipRestOfLine() {
        int charactersInFile = this.fileStorageObj.getCharactersInFile();
        boolean endOfLineFound = false;
        if (this.position < charactersInFile) {
            do {
                char currentCharacter = this.fileStorageObj.readCharacterAt(this.position);
                if (this.position == charactersInFile - 1) {
                    endOfLineFound = true;
                    this.endOfDictionaryReached = true;
                    continue;
                }
                if (currentCharacter == '\n') {
                    this.columnNumber = 0;
                    endOfLineFound = true;
                    ++this.position;
                    continue;
                }
                ++this.position;
            } while (!endOfLineFound);
        }
    }

    public final StringBuffer getRestOfLine() {
        int charactersInFile = this.fileStorageObj.getCharactersInFile();
        StringBuffer line = new StringBuffer();
        boolean endOfLineFound = false;
        line.setLength(0);
        if (this.position < charactersInFile) {
            do {
                char currentCharacter;
                if ((currentCharacter = this.fileStorageObj.readCharacterAt(this.position)) == '\n') {
                    this.columnNumber = 0;
                    endOfLineFound = true;
                    ++this.position;
                } else {
                    if (currentCharacter != '\r') {
                        line.append(currentCharacter);
                    }
                    ++this.position;
                }
                if (this.position != charactersInFile) continue;
                endOfLineFound = true;
                this.endOfDictionaryReached = true;
            } while (!endOfLineFound);
        }
        return line;
    }

    public final StringBuffer getWord() {
        int charactersInFile = this.fileStorageObj.getCharactersInFile();
        StringBuffer word = new StringBuffer();
        boolean endOfWordFound = false;
        word.setLength(0);
        if (this.position < charactersInFile) {
            do {
                char currentCharacter;
                if ((currentCharacter = this.fileStorageObj.readCharacterAt(this.position)) == '\n') {
                    this.columnNumber = 0;
                    endOfWordFound = true;
                    ++this.position;
                } else if (currentCharacter == this.separatorCharacter) {
                    ++this.columnNumber;
                    endOfWordFound = true;
                    ++this.position;
                } else {
                    if (currentCharacter != '\r') {
                        word.append(currentCharacter);
                    }
                    ++this.position;
                }
                if (this.position != charactersInFile) continue;
                endOfWordFound = true;
                this.endOfDictionaryReached = true;
            } while (!endOfWordFound);
        }
        return word;
    }

    public void setPositionBefore(String searchCriteria) {
        int lastPositionBefore;
        block6: {
            int charactersInFile = this.fileStorageObj.getCharactersInFile();
            lastPositionBefore = 0;
            int currentPosition = charactersInFile / 2;
            int lastPositionAfter = charactersInFile - 1;
            int numberOfLoops = 0;
            while (true) {
                ++numberOfLoops;
                while (currentPosition < charactersInFile && this.fileStorageObj.readCharacterAt(currentPosition) != '\n') {
                    ++currentPosition;
                }
                if (++currentPosition >= charactersInFile) break block6;
                this.position = currentPosition;
                StringBuffer word = this.getWord();
                int comparison = searchCriteria.compareTo(word.toString());
                if (comparison < 0) {
                    if (currentPosition != lastPositionAfter) {
                        lastPositionAfter = currentPosition;
                        currentPosition -= (currentPosition - lastPositionBefore) / 2;
                        continue;
                    }
                    break block6;
                }
                if (comparison > 0) {
                    if (currentPosition != lastPositionAfter) {
                        lastPositionBefore = currentPosition;
                        currentPosition += (lastPositionAfter - currentPosition) / 2;
                        continue;
                    }
                    break block6;
                }
                if (comparison == 0) break;
            }
            lastPositionBefore = currentPosition;
        }
        this.position = lastPositionBefore;
        Util.getUtil().log("pos before: " + this.position, 3);
    }

    public class stringFileStorage
    implements fileStorage {
        int charactersInFile;
        public String stringStorage;

        public stringFileStorage(StringBuffer content) throws IOException {
            this.stringStorage = content.toString();
            this.charactersInFile = this.stringStorage.length();
        }

        public stringFileStorage(byte[] content, int sizeOfFile, String charEncoding) throws IOException {
            this.stringStorage = new String(content, 0, sizeOfFile, charEncoding);
            this.charactersInFile = this.stringStorage.length();
        }

        public int getCharactersInFile() {
            return this.charactersInFile;
        }

        public char readCharacterAt(int pos) {
            return this.stringStorage.charAt(pos);
        }
    }

    public class byteFileStorage
    implements fileStorage {
        int charactersInFile;
        byte[] byteStorage;

        public byteFileStorage(byte[] content, int sizeOfFile) {
            this.byteStorage = content;
            this.charactersInFile = sizeOfFile;
        }

        public int getCharactersInFile() {
            return this.charactersInFile;
        }

        public char readCharacterAt(int pos) {
            return (char)this.byteStorage[pos];
        }
    }

    public static interface fileStorage {
        public int getCharactersInFile();

        public char readCharacterAt(int var1);
    }
}

